"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FlyoutContents = void 0;
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/kibana-react-plugin/public");
var _flyout = require("./flyout");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FlyoutContents = ({
  coreStart,
  share,
  data,
  props: {
    autoAddInference,
    indexSettings
  },
  onFlyoutClose,
  setUploadResults
}) => {
  return /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
    services: {
      ...coreStart,
      share,
      data
    }
  }, /*#__PURE__*/_react.default.createElement(_flyout.FileUploadLiteFlyoutContents, {
    autoAddInference: autoAddInference,
    indexSettings: indexSettings,
    onClose: () => {
      onFlyoutClose();
    },
    setUploadResults: setUploadResults
  }));
};
exports.FlyoutContents = FlyoutContents;