"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getESQLKeywordFieldStats = void 0;
var _common = require("@kbn/data-plugin/common");
var _pLimit = _interopRequireDefault(require("p-limit"));
var _esqlUtils = require("@kbn/esql-utils");
var _esql_utils = require("../requests/esql_utils");
var _promise_all_settled_utils = require("../../../common/util/promise_all_settled_utils");
var _index_data_visualizer_viewer = require("../../constants/index_data_visualizer_viewer");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getESQLKeywordFieldStats = async ({
  runRequest,
  columns,
  esqlBaseQuery,
  filter,
  timeRange
}) => {
  const limiter = (0, _pLimit.default)(_index_data_visualizer_viewer.MAX_CONCURRENT_REQUESTS);
  const namedParams = (0, _esqlUtils.getStartEndParams)(esqlBaseQuery, timeRange);
  const keywordFields = columns.map(field => {
    const query = (0, _esqlUtils.appendToESQLQuery)(esqlBaseQuery, `| STATS ${(0, _esql_utils.getSafeESQLName)(`${field.name}_in_records`)} = count(MV_MIN(${(0, _esql_utils.getSafeESQLName)(field.name)}))
    BY ${(0, _esql_utils.getSafeESQLName)(field.name)}
  | SORT ${(0, _esql_utils.getSafeESQLName)(`${field.name}_in_records`)} DESC
  | LIMIT 10`);
    return {
      field,
      request: {
        params: {
          query,
          ...(filter ? {
            filter
          } : {}),
          ...(namedParams.length ? {
            params: namedParams
          } : {})
        }
      }
    };
  });
  if (keywordFields.length > 0) {
    const keywordTopTermsResp = await Promise.allSettled(keywordFields.map(({
      request
    }) => limiter(() => runRequest(request, {
      strategy: _common.ESQL_ASYNC_SEARCH_STRATEGY
    }))));
    if (keywordTopTermsResp) {
      return keywordFields.map(({
        field,
        request
      }, idx) => {
        const resp = keywordTopTermsResp[idx];
        if (!resp) return;
        if ((0, _promise_all_settled_utils.isFulfilled)(resp)) {
          var _resp$value, _resp$value$rawRespon;
          const results = (_resp$value = resp.value) === null || _resp$value === void 0 ? void 0 : (_resp$value$rawRespon = _resp$value.rawResponse) === null || _resp$value$rawRespon === void 0 ? void 0 : _resp$value$rawRespon.values;
          if (results) {
            const topValuesSampleSize = results.reduce((acc, row) => {
              return row[0] + acc;
            }, 0);
            const terms = results.map(row => ({
              key: row[1],
              doc_count: row[0]
            }));
            return {
              fieldName: field.name,
              topValues: terms,
              isTopValuesSampled: true,
              approximate: true,
              topValuesSampleSize
            };
          }
          return;
        }
        if ((0, _promise_all_settled_utils.isRejected)(resp)) {
          // Log for debugging purposes
          // eslint-disable-next-line no-console
          console.error(resp, request);
          return {
            fieldName: field.name,
            error: resp.reason
          };
        }
      });
    }
  }
  return [];
};
exports.getESQLKeywordFieldStats = getESQLKeywordFieldStats;