"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GeoPointContent = exports.DEFAULT_GEO_REGEX = void 0;
var _react = _interopRequireWildcard(require("react"));
var _document_stats = require("../../stats_table/components/field_data_expanded_row/document_stats");
var _format_utils = require("./format_utils");
var _expanded_row_content = require("../../stats_table/components/field_data_expanded_row/expanded_row_content");
var _examples_list = require("../../examples_list");
var _expanded_row_panel = require("../../stats_table/components/field_data_expanded_row/expanded_row_panel");
var _kibana_context = require("../../../../kibana_context");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_GEO_REGEX = exports.DEFAULT_GEO_REGEX = RegExp('(?<lat>.+) (?<lon>.+)');
const GeoPointContent = ({
  config
}) => {
  const {
    services: {
      maps: mapsService
    }
  } = (0, _kibana_context.useDataVisualizerKibana)();
  const formattedResults = (0, _react.useMemo)(() => {
    const {
      stats
    } = config;
    if (stats === undefined || stats.topValues === undefined) return null;
    if (Array.isArray(stats.topValues)) {
      const geoPointsFeatures = [];

      // reformatting the top values from POINT (-2.359207 51.37837) to (-2.359207, 51.37837)
      const formattedExamples = [];
      for (let i = 0; i < stats.topValues.length; i++) {
        const value = stats.topValues[i];
        const coordinates = (0, _format_utils.convertWKTGeoToLonLat)(value.key);
        if (coordinates) {
          const formattedGeoPoint = `(${coordinates.lat}, ${coordinates.lon})`;
          formattedExamples.push(coordinates);
          geoPointsFeatures.push({
            type: 'Feature',
            id: `fileDataVisualizer-${config.fieldName}-${i}`,
            geometry: {
              type: 'Point',
              coordinates: [coordinates.lat, coordinates.lon]
            },
            properties: {
              value: formattedGeoPoint,
              count: value.doc_count
            }
          });
        }
      }
      if (geoPointsFeatures.length > 0) {
        return {
          examples: formattedExamples,
          pointsLayer: (0, _format_utils.getGeoPointsLayer)(geoPointsFeatures)
        };
      }
    }
  }, [config]);
  return /*#__PURE__*/_react.default.createElement(_expanded_row_content.ExpandedRowContent, {
    dataTestSubj: 'dataVisualizerGeoPointContent'
  }, /*#__PURE__*/_react.default.createElement(_document_stats.DocumentStatsTable, {
    config: config
  }), (formattedResults === null || formattedResults === void 0 ? void 0 : formattedResults.examples) && /*#__PURE__*/_react.default.createElement(_examples_list.ExamplesList, {
    examples: formattedResults.examples
  }), mapsService && (formattedResults === null || formattedResults === void 0 ? void 0 : formattedResults.pointsLayer) && /*#__PURE__*/_react.default.createElement(_expanded_row_panel.ExpandedRowPanel, {
    className: 'dvPanel__wrapper dvMap__wrapper',
    grow: true
  }, /*#__PURE__*/_react.default.createElement(mapsService.PassiveMap, {
    passiveLayer: formattedResults.pointsLayer
  })));
};
exports.GeoPointContent = GeoPointContent;