"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.stateSchemaByVersion = exports.emptyState = void 0;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * WARNING: Do not modify the existing versioned schema(s) below, instead define a new version (ex: 2, 3, 4).
 * This is required to support zero-downtime upgrades and rollbacks. See https://github.com/elastic/kibana/issues/155764.
 *
 * As you add a new schema version, don't forget to change latestTaskStateSchema variable to reference the latest schema.
 * For example, changing stateSchemaByVersion[1].schema to stateSchemaByVersion[2].schema.
 */
const stateSchemaByVersion = exports.stateSchemaByVersion = {
  1: {
    // A task that was created < 8.10 will go through this "up" migration
    // to ensure it matches the v1 schema.
    up: state => {
      var _state$telemetry, _state$telemetry$pane, _state$telemetry2, _state$telemetry2$pan, _state$telemetry3, _state$telemetry3$pan, _state$telemetry4, _state$telemetry4$pan, _state$telemetry5, _state$telemetry5$con, _state$telemetry6, _state$telemetry6$con, _state$telemetry7, _state$telemetry7$con, _state$telemetry8, _state$telemetry8$con, _state$telemetry9, _state$telemetry9$con;
      return {
        runs: typeof state.runs === 'number' ? state.runs : 0,
        telemetry: {
          panels: {
            total: ((_state$telemetry = state.telemetry) === null || _state$telemetry === void 0 ? void 0 : (_state$telemetry$pane = _state$telemetry.panels) === null || _state$telemetry$pane === void 0 ? void 0 : _state$telemetry$pane.total) || 0,
            by_reference: ((_state$telemetry2 = state.telemetry) === null || _state$telemetry2 === void 0 ? void 0 : (_state$telemetry2$pan = _state$telemetry2.panels) === null || _state$telemetry2$pan === void 0 ? void 0 : _state$telemetry2$pan.by_reference) || 0,
            by_value: ((_state$telemetry3 = state.telemetry) === null || _state$telemetry3 === void 0 ? void 0 : (_state$telemetry3$pan = _state$telemetry3.panels) === null || _state$telemetry3$pan === void 0 ? void 0 : _state$telemetry3$pan.by_value) || 0,
            by_type: ((_state$telemetry4 = state.telemetry) === null || _state$telemetry4 === void 0 ? void 0 : (_state$telemetry4$pan = _state$telemetry4.panels) === null || _state$telemetry4$pan === void 0 ? void 0 : _state$telemetry4$pan.by_type) || {}
          },
          controls: {
            total: ((_state$telemetry5 = state.telemetry) === null || _state$telemetry5 === void 0 ? void 0 : (_state$telemetry5$con = _state$telemetry5.controls) === null || _state$telemetry5$con === void 0 ? void 0 : _state$telemetry5$con.total) || 0,
            chaining_system: ((_state$telemetry6 = state.telemetry) === null || _state$telemetry6 === void 0 ? void 0 : (_state$telemetry6$con = _state$telemetry6.controls) === null || _state$telemetry6$con === void 0 ? void 0 : _state$telemetry6$con.chaining_system) || {},
            label_position: ((_state$telemetry7 = state.telemetry) === null || _state$telemetry7 === void 0 ? void 0 : (_state$telemetry7$con = _state$telemetry7.controls) === null || _state$telemetry7$con === void 0 ? void 0 : _state$telemetry7$con.label_position) || {},
            ignore_settings: ((_state$telemetry8 = state.telemetry) === null || _state$telemetry8 === void 0 ? void 0 : (_state$telemetry8$con = _state$telemetry8.controls) === null || _state$telemetry8$con === void 0 ? void 0 : _state$telemetry8$con.ignore_settings) || {},
            by_type: ((_state$telemetry9 = state.telemetry) === null || _state$telemetry9 === void 0 ? void 0 : (_state$telemetry9$con = _state$telemetry9.controls) === null || _state$telemetry9$con === void 0 ? void 0 : _state$telemetry9$con.by_type) || {}
          }
        }
      };
    },
    schema: _configSchema.schema.object({
      runs: _configSchema.schema.number(),
      telemetry: _configSchema.schema.object({
        panels: _configSchema.schema.object({
          total: _configSchema.schema.number(),
          by_reference: _configSchema.schema.number(),
          by_value: _configSchema.schema.number(),
          by_type: _configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.object({
            total: _configSchema.schema.number(),
            by_reference: _configSchema.schema.number(),
            by_value: _configSchema.schema.number(),
            details: _configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.number())
          }))
        }),
        controls: _configSchema.schema.object({
          total: _configSchema.schema.number(),
          chaining_system: _configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.number()),
          label_position: _configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.number()),
          ignore_settings: _configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.number()),
          by_type: _configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.object({
            total: _configSchema.schema.number(),
            details: _configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.number())
          }))
        })
      })
    })
  }
};
const latestTaskStateSchema = stateSchemaByVersion[1].schema;
const emptyState = exports.emptyState = {
  runs: 0,
  telemetry: {
    panels: {
      total: 0,
      by_reference: 0,
      by_value: 0,
      by_type: {}
    },
    controls: {
      total: 0,
      chaining_system: {},
      ignore_settings: {},
      label_position: {},
      by_type: {}
    }
  }
};