"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getMenuItemGroups = getMenuItemGroups;
var _public = require("@kbn/visualizations-plugin/public");
var _public2 = require("@kbn/ui-actions-plugin/public");
var _public3 = require("@kbn/embeddable-plugin/public");
var _kibana_services = require("../../../services/kibana_services");
var _navigate_to_vis_editor = require("./navigate_to_vis_editor");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const VIS_GROUP_TO_ADD_PANEL_GROUP = {
  [_public.VisGroups.PROMOTED]: _public3.ADD_PANEL_VISUALIZATION_GROUP,
  [_public.VisGroups.TOOLS]: _public3.ADD_PANEL_ANNOTATION_GROUP
};
async function getMenuItemGroups(api) {
  const groups = {};
  const addPanelContext = {
    embeddable: api,
    trigger: _public2.addPanelMenuTrigger
  };
  function pushItem(group, item) {
    if (!groups[group.id]) {
      var _group$getDisplayName, _group$getDisplayName2, _group$order;
      groups[group.id] = {
        id: group.id,
        title: (_group$getDisplayName = (_group$getDisplayName2 = group.getDisplayName) === null || _group$getDisplayName2 === void 0 ? void 0 : _group$getDisplayName2.call(group, addPanelContext)) !== null && _group$getDisplayName !== void 0 ? _group$getDisplayName : '',
        'data-test-subj': `dashboardEditorMenu-${group.id}Group`,
        order: (_group$order = group.order) !== null && _group$order !== void 0 ? _group$order : 0,
        items: []
      };
    }
    groups[group.id].items.push(item);
  }

  // add menu items from vis types
  _kibana_services.visualizationsService.all().forEach(visType => {
    var _visType$icon;
    if (visType.disableCreate) return;
    const group = VIS_GROUP_TO_ADD_PANEL_GROUP[visType.group];
    if (!group) return;
    pushItem(group, {
      id: visType.name,
      name: visType.titleInWizard || visType.title,
      isDeprecated: visType.isDeprecated,
      icon: (_visType$icon = visType.icon) !== null && _visType$icon !== void 0 ? _visType$icon : 'empty',
      onClick: () => {
        api.clearOverlays();
        (0, _navigate_to_vis_editor.navigateToVisEditor)(api, visType);
      },
      'data-test-subj': `visType-${visType.name}`,
      description: visType.description,
      order: visType.order
    });
  });

  // add menu items from vis alias
  _kibana_services.visualizationsService.getAliases().forEach(visTypeAlias => {
    var _visTypeAlias$icon, _visTypeAlias$order;
    if (visTypeAlias.disableCreate) return;
    pushItem(_public3.ADD_PANEL_VISUALIZATION_GROUP, {
      id: visTypeAlias.name,
      name: visTypeAlias.title,
      icon: (_visTypeAlias$icon = visTypeAlias.icon) !== null && _visTypeAlias$icon !== void 0 ? _visTypeAlias$icon : 'empty',
      onClick: () => {
        api.clearOverlays();
        (0, _navigate_to_vis_editor.navigateToVisEditor)(api, visTypeAlias);
      },
      'data-test-subj': `visType-${visTypeAlias.name}`,
      description: visTypeAlias.description,
      order: (_visTypeAlias$order = visTypeAlias.order) !== null && _visTypeAlias$order !== void 0 ? _visTypeAlias$order : 0
    });
  });

  // add menu items from "add panel" actions
  (await _kibana_services.uiActionsService.getTriggerCompatibleActions(_public2.ADD_PANEL_TRIGGER, {
    embeddable: api
  })).forEach(action => {
    const actionGroups = Array.isArray(action.grouping) ? action.grouping : [_public3.ADD_PANEL_OTHER_GROUP];
    actionGroups.forEach(group => {
      var _action$getIconType, _action$getIconType2, _action$getDisplayNam, _action$order;
      const actionName = action.getDisplayName(addPanelContext);
      pushItem(group, {
        id: action.id,
        name: actionName,
        icon: (_action$getIconType = (_action$getIconType2 = action.getIconType) === null || _action$getIconType2 === void 0 ? void 0 : _action$getIconType2.call(action, addPanelContext)) !== null && _action$getIconType !== void 0 ? _action$getIconType : 'empty',
        onClick: event => {
          api.clearOverlays();
          if (event.currentTarget instanceof HTMLAnchorElement) {
            if (!event.defaultPrevented &&
            // onClick prevented default
            event.button === 0 && (!event.currentTarget.target || event.currentTarget.target === '_self') && !(event.metaKey || event.altKey || event.ctrlKey || event.shiftKey)) {
              event.preventDefault();
            }
          }
          action.execute(addPanelContext);
        },
        'data-test-subj': `create-action-${actionName}`,
        description: action === null || action === void 0 ? void 0 : (_action$getDisplayNam = action.getDisplayNameTooltip) === null || _action$getDisplayNam === void 0 ? void 0 : _action$getDisplayNam.call(action, addPanelContext),
        order: (_action$order = action.order) !== null && _action$order !== void 0 ? _action$order : 0
      });
    });
  });
  return Object.values(groups).map(group => {
    group.items.sort((itemA, itemB) => {
      return itemA.order === itemB.order ? itemA.name.localeCompare(itemB.name) : itemB.order - itemA.order;
    });
    return group;
  }).sort((groupA, groupB) => groupB.order - groupA.order);
}