"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.performOpenPointInTime = void 0;
var _boom = _interopRequireDefault(require("@hapi/boom"));
var _coreElasticsearchServerInternal = require("@kbn/core-elasticsearch-server-internal");
var _coreSavedObjectsServer = require("@kbn/core-saved-objects-server");
var _coreSavedObjectsUtilsServer = require("@kbn/core-saved-objects-utils-server");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const performOpenPointInTime = async ({
  type,
  options,
  internalOptions
}, {
  helpers,
  allowedTypes: rawAllowedTypes,
  client,
  extensions = {}
}) => {
  const {
    common: commonHelper
  } = helpers;
  const {
    securityExtension,
    spacesExtension
  } = extensions;
  const {
    disableExtensions
  } = internalOptions;
  let namespaces;
  if (disableExtensions || !spacesExtension) {
    var _options$namespaces;
    namespaces = (_options$namespaces = options.namespaces) !== null && _options$namespaces !== void 0 ? _options$namespaces : [_coreSavedObjectsUtilsServer.DEFAULT_NAMESPACE_STRING];
    // If the consumer specified `namespaces: []`, throw a Bad Request error
    if (namespaces.length === 0) throw _coreSavedObjectsServer.SavedObjectsErrorHelpers.createBadRequestError('options.namespaces cannot be an empty array');
  }
  const {
    keepAlive = '5m',
    preference
  } = options;
  const types = Array.isArray(type) ? type : [type];
  const allowedTypes = types.filter(t => rawAllowedTypes.includes(t));
  if (allowedTypes.length === 0) {
    throw _coreSavedObjectsServer.SavedObjectsErrorHelpers.createGenericNotFoundError();
  }
  if (!disableExtensions && spacesExtension) {
    try {
      namespaces = await spacesExtension.getSearchableNamespaces(options.namespaces);
    } catch (err) {
      if (_boom.default.isBoom(err) && err.output.payload.statusCode === 403) {
        // The user is not authorized to access any space, throw a bad request error.
        throw _coreSavedObjectsServer.SavedObjectsErrorHelpers.createBadRequestError();
      }
      throw err;
    }
    if (namespaces.length === 0) {
      // The user is authorized to access *at least one space*, but not any of the spaces they requested; throw a bad request error.
      throw _coreSavedObjectsServer.SavedObjectsErrorHelpers.createBadRequestError();
    }
  }
  if (!disableExtensions && securityExtension) {
    await securityExtension.authorizeOpenPointInTime({
      namespaces: new Set(namespaces),
      types: new Set(types)
    });
  }
  const esOptions = {
    index: commonHelper.getIndicesForTypes(allowedTypes),
    keep_alive: keepAlive,
    ...(preference ? {
      preference
    } : {})
  };
  const {
    body,
    statusCode,
    headers
  } = await client.openPointInTime(esOptions, {
    ignore: [404],
    meta: true
  });
  if (statusCode === 404) {
    if (!(0, _coreElasticsearchServerInternal.isSupportedEsServer)(headers)) {
      throw _coreSavedObjectsServer.SavedObjectsErrorHelpers.createGenericNotFoundEsUnavailableError();
    } else {
      throw _coreSavedObjectsServer.SavedObjectsErrorHelpers.createGenericNotFoundError();
    }
  }
  return {
    id: body.id
  };
};
exports.performOpenPointInTime = performOpenPointInTime;