"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initializeDefaultControlApi = void 0;
var _rxjs = require("rxjs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const initializeDefaultControlApi = state => {
  const dataLoading$ = new _rxjs.BehaviorSubject(false);
  const blockingError$ = new _rxjs.BehaviorSubject(undefined);
  const grow = new _rxjs.BehaviorSubject(state.grow);
  const width = new _rxjs.BehaviorSubject(state.width);
  return {
    api: {
      grow,
      width,
      dataLoading$,
      blockingError$,
      setBlockingError: error => blockingError$.next(error),
      setDataLoading: loading => dataLoading$.next(loading)
    },
    comparators: {
      grow: [grow, newGrow => grow.next(newGrow)],
      width: [width, newWidth => width.next(newWidth)]
    },
    stateManager: {
      grow,
      width
    },
    serialize: () => {
      return {
        rawState: {
          grow: grow.getValue(),
          width: width.getValue()
        },
        references: []
      };
    }
  };
};
exports.initializeDefaultControlApi = initializeDefaultControlApi;