"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.favoritesSavedObjectType = exports.favoritesSavedObjectName = void 0;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const schemaV1 = _configSchema.schema.object({
  userId: _configSchema.schema.string(),
  type: _configSchema.schema.string(),
  // object type, e.g. dashboard
  favoriteIds: _configSchema.schema.arrayOf(_configSchema.schema.string())
});
const schemaV3 = schemaV1.extends({
  favoriteMetadata: _configSchema.schema.maybe(_configSchema.schema.object({}, {
    unknowns: 'allow'
  }))
});
const favoritesSavedObjectName = exports.favoritesSavedObjectName = 'favorites';
const favoritesSavedObjectType = exports.favoritesSavedObjectType = {
  name: favoritesSavedObjectName,
  hidden: true,
  namespaceType: 'single',
  mappings: {
    dynamic: false,
    properties: {
      userId: {
        type: 'keyword'
      },
      type: {
        type: 'keyword'
      },
      favoriteIds: {
        type: 'keyword'
      },
      favoriteMetadata: {
        type: 'object',
        dynamic: false
      }
    }
  },
  modelVersions: {
    1: {
      changes: [],
      schemas: {
        // The forward compatible schema should allow any future versions of
        // this SO to be converted to this version, since we are using
        // @kbn/config-schema we opt-in to unknowns to allow the schema to
        // successfully "downgrade" future SOs to this version.
        forwardCompatibility: schemaV1.extends({}, {
          unknowns: 'ignore'
        }),
        create: schemaV1
      }
    },
    2: {
      // the model stays the same, but we added the mappings for the snapshot telemetry needs
      changes: [{
        type: 'mappings_addition',
        addedMappings: {
          userId: {
            type: 'keyword'
          },
          type: {
            type: 'keyword'
          },
          favoriteIds: {
            type: 'keyword'
          }
        }
      }],
      schemas: {
        forwardCompatibility: schemaV1.extends({}, {
          unknowns: 'ignore'
        }),
        create: schemaV1
      }
    },
    3: {
      changes: [{
        type: 'mappings_addition',
        addedMappings: {
          favoriteMetadata: {
            type: 'object',
            dynamic: false
          }
        }
      }],
      schemas: {
        forwardCompatibility: schemaV3.extends({}, {
          unknowns: 'ignore'
        }),
        create: schemaV3
      }
    }
  }
};