"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CspPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/kibana-react-plugin/public");
var _public2 = require("@kbn/kibana-utils-plugin/public");
var _sharedUxLinkRedirectApp = require("@kbn/shared-ux-link-redirect-app");
var _ui_metrics = require("@kbn/cloud-security-posture-common/utils/ui_metrics");
var _csp_loading_state = require("./components/csp_loading_state");
var _constants = require("../common/constants");
var _setup_context = require("./application/setup_context");
var _experimental_features = require("../common/experimental_features");
var _experimental_features_service = require("./common/experimental_features_service");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const LazyCspPolicyTemplateForm = /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./components/fleet_extensions/policy_template_form'))));
const LazyCspCustomAssets = /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./components/fleet_extensions/custom_assets_extension'))));
const CspRouterLazy = /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./application/csp_router'))));
const CspRouter = props => /*#__PURE__*/_react.default.createElement(_react.Suspense, {
  fallback: /*#__PURE__*/_react.default.createElement(_csp_loading_state.CspLoadingState, null)
}, /*#__PURE__*/_react.default.createElement(CspRouterLazy, props));
class CspPlugin {
  constructor(initializerContext) {
    var _parseExperimentalCon;
    (0, _defineProperty2.default)(this, "isCloudEnabled", void 0);
    (0, _defineProperty2.default)(this, "config", void 0);
    (0, _defineProperty2.default)(this, "experimentalFeatures", void 0);
    this.initializerContext = initializerContext;
    this.config = this.initializerContext.config.get();
    this.experimentalFeatures = (_parseExperimentalCon = (0, _experimental_features.parseExperimentalConfigValue)(this.config.enableExperimental || [])) === null || _parseExperimentalCon === void 0 ? void 0 : _parseExperimentalCon.features;
  }
  setup(_core, plugins) {
    this.isCloudEnabled = plugins.cloud.isCloudEnabled;
    if (plugins.usageCollection) _ui_metrics.uiMetricService.setup(plugins.usageCollection);

    // Return methods that should be available to other plugins
    return {};
  }
  start(core, plugins) {
    _experimental_features_service.ExperimentalFeaturesService.init({
      experimentalFeatures: this.experimentalFeatures
    });
    plugins.fleet.registerExtension({
      package: _constants.CLOUD_SECURITY_POSTURE_PACKAGE_NAME,
      view: 'package-policy-replace-define-step',
      Component: LazyCspPolicyTemplateForm
    });
    plugins.fleet.registerExtension({
      package: _constants.CLOUD_SECURITY_POSTURE_PACKAGE_NAME,
      view: 'package-detail-assets',
      Component: LazyCspCustomAssets
    });
    const storage = new _public2.Storage(localStorage);

    // Keep as constant to prevent remounts https://github.com/elastic/kibana/issues/146773
    const App = props => /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
      services: {
        ...core,
        ...plugins,
        storage
      }
    }, /*#__PURE__*/_react.default.createElement(_sharedUxLinkRedirectApp.RedirectAppLinks, {
      coreStart: core
    }, /*#__PURE__*/_react.default.createElement("div", {
      style: {
        width: '100%',
        height: '100%'
      }
    }, /*#__PURE__*/_react.default.createElement(_setup_context.SetupContext.Provider, {
      value: {
        isCloudEnabled: this.isCloudEnabled
      }
    }, /*#__PURE__*/_react.default.createElement(CspRouter, props)))));
    return {
      getCloudSecurityPostureRouter: () => App
    };
  }
  stop() {}
}
exports.CspPlugin = CspPlugin;