"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAllAlertsAttachedToCaseRoute = void 0;
var _configSchema = require("@kbn/config-schema");
var _constants = require("../../../../common/constants");
var _error = require("../../../common/error");
var _create_cases_route = require("../create_cases_route");
var _constants2 = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getAllAlertsAttachedToCaseRoute = exports.getAllAlertsAttachedToCaseRoute = (0, _create_cases_route.createCasesRoute)({
  method: 'get',
  path: _constants.CASE_DETAILS_ALERTS_URL,
  security: _constants2.DEFAULT_CASES_ROUTE_SECURITY,
  params: {
    params: _configSchema.schema.object({
      case_id: _configSchema.schema.string({
        minLength: 1
      })
    })
  },
  routerOptions: {
    access: 'public',
    summary: `Get all alerts for a case`,
    tags: ['oas-tag:cases']
    // description: 'You must have `read` privileges for the **Cases** feature in the **Management**, **Observability**, or **Security** section of the Kibana feature privileges, depending on the owner of the cases you\'re seeking.',
  },
  handler: async ({
    context,
    request,
    response
  }) => {
    try {
      const caseId = request.params.case_id;
      const caseContext = await context.cases;
      const casesClient = await caseContext.getCasesClient();
      const res = await casesClient.attachments.getAllAlertsAttachToCase({
        caseId
      });
      return response.ok({
        body: res
      });
    } catch (error) {
      throw (0, _error.createCaseError)({
        message: `Failed to retrieve alert ids for this case id: ${request.params.case_id}: ${error}`,
        error
      });
    }
  }
});