"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GROUPED_BY_TITLE = exports.GROUPED_BY_DESC = exports.CASE_CREATED_BY_RULE_DESC = exports.AUTO_CREATED_TITLE = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CASE_CREATED_BY_RULE_DESC = ruleName => _i18n.i18n.translate('xpack.cases.caseAction.caseCreatedByRuleDesc', {
  defaultMessage: 'This case was created by the rule {ruleName}',
  values: {
    ruleName
  }
});
exports.CASE_CREATED_BY_RULE_DESC = CASE_CREATED_BY_RULE_DESC;
const GROUPED_BY_DESC = groupingDescription => _i18n.i18n.translate('xpack.cases.caseAction.groupedByDesc', {
  defaultMessage: 'The assigned alerts are grouped by {groupingDescription}',
  values: {
    groupingDescription
  }
});
exports.GROUPED_BY_DESC = GROUPED_BY_DESC;
const GROUPED_BY_TITLE = groupingDescription => _i18n.i18n.translate('xpack.cases.caseAction.groupedByTitle', {
  defaultMessage: 'Grouping by {groupingDescription}',
  values: {
    groupingDescription
  }
});
exports.GROUPED_BY_TITLE = GROUPED_BY_TITLE;
const AUTO_CREATED_TITLE = exports.AUTO_CREATED_TITLE = _i18n.i18n.translate('xpack.cases.caseAction.autoCreatedTitle', {
  defaultMessage: 'Auto-created'
});