"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SnippetsStep = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _constants = require("../../../../../i18n/constants");
var _clipboard = require("../../../clipboard");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const strings = {
  getAutoplayParameterDescription: () => _i18n.i18n.translate('xpack.canvas.shareWebsiteFlyout.snippetsStep.autoplayParameterDescription', {
    defaultMessage: 'Should the runtime automatically move through the pages of the workpad?'
  }),
  getCallRuntimeLabel: () => _i18n.i18n.translate('xpack.canvas.shareWebsiteFlyout.snippetsStep.callRuntimeLabel', {
    defaultMessage: 'Call Runtime'
  }),
  getHeightParameterDescription: () => _i18n.i18n.translate('xpack.canvas.shareWebsiteFlyout.snippetsStep.heightParameterDescription', {
    defaultMessage: 'The height of the Workpad. Defaults to the Workpad height.'
  }),
  getIncludeRuntimeLabel: () => _i18n.i18n.translate('xpack.canvas.shareWebsiteFlyout.snippetsStep.includeRuntimeLabel', {
    defaultMessage: 'Include Runtime'
  }),
  getIntervalParameterDescription: () => _i18n.i18n.translate('xpack.canvas.shareWebsiteFlyout.snippetsStep.intervalParameterDescription', {
    defaultMessage: 'The interval upon which the pages will advance in time format, (e.g. {twoSeconds}, {oneMinute})',
    values: {
      twoSeconds: '2s',
      oneMinute: '1m'
    }
  }),
  getPageParameterDescription: () => _i18n.i18n.translate('xpack.canvas.shareWebsiteFlyout.snippetsStep.pageParameterDescription', {
    defaultMessage: 'The page to display. Defaults to the page specified by the Workpad.'
  }),
  getParametersDescription: () => _i18n.i18n.translate('xpack.canvas.shareWebsiteFlyout.snippetsStep.parametersDescription', {
    defaultMessage: 'There are a number of inline parameters to configure the Shareable Workpad.'
  }),
  getParametersTitle: () => _i18n.i18n.translate('xpack.canvas.shareWebsiteFlyout.snippetsStep.parametersLabel', {
    defaultMessage: 'Parameters'
  }),
  getPlaceholderLabel: () => _i18n.i18n.translate('xpack.canvas.shareWebsiteFlyout.snippetsStep.placeholderLabel', {
    defaultMessage: 'Placeholder'
  }),
  getRequiredLabel: () => _i18n.i18n.translate('xpack.canvas.shareWebsiteFlyout.snippetsStep.requiredLabel', {
    defaultMessage: 'required'
  }),
  getShareableParameterDescription: () => _i18n.i18n.translate('xpack.canvas.shareWebsiteFlyout.snippetsStep.shareableParameterDescription', {
    defaultMessage: 'The type of shareable. In this case, a {CANVAS} Workpad.',
    values: {
      CANVAS: _constants.CANVAS
    }
  }),
  getSnippetsStepDescription: () => _i18n.i18n.translate('xpack.canvas.shareWebsiteFlyout.snippetsStep.description', {
    defaultMessage: 'The Workpad is placed within the {HTML} of the site by using an {HTML} placeholder. Parameters for the runtime are included inline. See the full list of parameters below. You can include more than one workpad on the page.',
    values: {
      HTML
    }
  }),
  getToolbarParameterDescription: () => _i18n.i18n.translate('xpack.canvas.shareWebsiteFlyout.snippetsStep.toolbarParameterDescription', {
    defaultMessage: 'Should the toolbar be hidden?'
  }),
  getUrlParameterDescription: () => _i18n.i18n.translate('xpack.canvas.shareWebsiteFlyout.snippetsStep.urlParameterDescription', {
    defaultMessage: 'The {URL} of the Shareable Workpad {JSON} file.',
    values: {
      URL: _constants.URL,
      JSON: _constants.JSON
    }
  }),
  getWidthParameterDescription: () => _i18n.i18n.translate('xpack.canvas.shareWebsiteFlyout.snippetsStep.widthParameterDescription', {
    defaultMessage: 'The width of the Workpad. Defaults to the Workpad width.'
  })
};
const HTML = `<!-- ${strings.getIncludeRuntimeLabel()} -->
<script src="kbn_canvas.js"></script>

<!-- ${strings.getPlaceholderLabel()} -->
<div kbn-canvas-shareable="canvas" kbn-canvas-url="workpad.json" />

<!-- ${strings.getCallRuntimeLabel()} -->
<script type="text/javascript">
  KbnCanvas.share();
</script>`;
const SnippetsStep = ({
  onCopy
}) => /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  size: "s"
}, /*#__PURE__*/_react.default.createElement("p", null, strings.getSnippetsStepDescription())), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "s"
}), /*#__PURE__*/_react.default.createElement(_clipboard.Clipboard, {
  content: HTML,
  onCopy: onCopy
}, /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
  className: "canvasShareMenu__reportingConfig",
  paddingSize: "s",
  fontSize: "s",
  language: "html"
}, HTML)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("h4", null, strings.getParametersTitle()), /*#__PURE__*/_react.default.createElement("p", null, strings.getParametersDescription())), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, null), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "kbn-canvas-shareable=\"canvas\""), " (", strings.getRequiredLabel(), ")"), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, null, strings.getShareableParameterDescription()), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "kbn-canvas-url"), " (", strings.getRequiredLabel(), ")"), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, null, strings.getUrlParameterDescription()), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "kbn-canvas-height")), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, null, strings.getHeightParameterDescription()), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "kbn-canvas-width")), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, null, strings.getWidthParameterDescription()), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "kbn-canvas-page")), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, null, strings.getPageParameterDescription()), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "kbn-canvas-autoplay")), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, null, strings.getAutoplayParameterDescription()), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "kbn-canvas-interval")), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, null, strings.getIntervalParameterDescription()), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "kbn-canvas-toolbar")), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, null, strings.getToolbarParameterDescription())));
exports.SnippetsStep = SnippetsStep;