"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCanvasFilters = useCanvasFilters;
var _react = require("react");
var _interpreter = require("@kbn/interpreter");
var _reactRedux = require("react-redux");
var _filter = require("../../../lib/filter");
var _filter_adapters = require("../../../lib/filter_adapters");
var _canvas_filters_service = require("../../../services/canvas_filters_service");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const extractExpressionAST = filters => (0, _interpreter.fromExpression)(filters.join(' | '));
function useCanvasFilters(filterExprsToGroupBy = []) {
  const filtersService = (0, _react.useMemo)(() => (0, _canvas_filters_service.getCanvasFiltersService)(), []);
  const filterExpressions = (0, _reactRedux.useSelector)(state => filtersService.getFilters(state), _reactRedux.shallowEqual);
  const filtersByGroups = (0, _filter.getFiltersByFilterExpressions)(filterExpressions, filterExprsToGroupBy);
  const expression = extractExpressionAST(filtersByGroups);
  const filters = expression.chain.map(_filter_adapters.adaptCanvasFilter);
  return filters;
}