"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TagList = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _get_id = require("../../lib/get_id");
var _tag = require("../tag");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TagList = ({
  tags = [],
  tagType = 'health',
  getTag
}) => /*#__PURE__*/_react.default.createElement(_react.Fragment, null, tags.length ? tags.map(tag => {
  const {
    color,
    name
  } = getTag(tag);
  const id = (0, _get_id.getId)('tag');
  return /*#__PURE__*/_react.default.createElement(_tag.Tag, {
    key: id,
    color: color,
    name: name,
    type: tagType
  });
}) : null);
exports.TagList = TagList;
TagList.propTypes = {
  tags: _propTypes.default.array,
  tagType: _propTypes.default.oneOf(['health', 'badge']),
  getTag: _propTypes.default.func.isRequired
};