"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CanvasLoading = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const strings = {
  getLoadingLabel: () => _i18n.i18n.translate('xpack.canvas.canvasLoading.loadingMessage', {
    defaultMessage: 'Loading'
  })
};
const CanvasLoading = ({
  msg = `${strings.getLoadingLabel()}...`
}) => /*#__PURE__*/_react.default.createElement("div", {
  className: "canvasContainer--loading"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, null, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingChart, {
  size: "m"
}), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "s"
}), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  color: "default",
  size: "s"
}, /*#__PURE__*/_react.default.createElement("p", null, msg))));
exports.CanvasLoading = CanvasLoading;