"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.handleErrors = handleErrors;
var _output_parsers = require("@langchain/core/output_parsers");
var _processors = require("../../util/processors");
var _prompts = require("./prompts");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function handleErrors({
  state,
  model
}) {
  const categorizationErrorPrompt = _prompts.CATEGORIZATION_ERROR_PROMPT;
  const outputParser = new _output_parsers.JsonOutputParser();
  const categorizationErrorGraph = categorizationErrorPrompt.pipe(model).pipe(outputParser);
  const currentProcessors = await categorizationErrorGraph.invoke({
    current_processors: JSON.stringify(state.currentProcessors, null, 2),
    ex_answer: state.exAnswer,
    errors: JSON.stringify(state.errors, null, 2),
    package_name: state.packageName,
    data_stream_name: state.dataStreamName
  });
  const processors = {
    type: 'categorization',
    processors: currentProcessors
  };
  const currentPipeline = (0, _processors.combineProcessors)(state.initialPipeline, processors);
  return {
    currentPipeline,
    currentProcessors,
    lastExecutedChain: 'error'
  };
}