"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TECH_PREVIEW_TOOLTIP = exports.TECH_PREVIEW = exports.RETRY = exports.PROGRESS_RELATED_GRAPH = exports.PROGRESS_ECS_MAPPING = exports.PROGRESS_CATEGORIZATION = exports.PROGRESS_ANALYZE_LOGS = exports.PACKAGE_NAMES_FETCH_ERROR = exports.OPEN_API_SPEC_BUTTON_CONFIGURED = exports.NO_SPACES_HELP = exports.NAME_ALREADY_EXISTS_ERROR = exports.LOGS_SAMPLE_WARNING = exports.LOGS_SAMPLE_LABEL = exports.LOGS_SAMPLE_ERROR = exports.LOGS_SAMPLE_DESCRIPTION = exports.INTEGRATION_NAME_TITLE = exports.INTEGRATION_NAME_LABEL = exports.INTEGRATION_NAME_DESCRIPTION = exports.GENERATION_ERROR_TRANSLATION = exports.GENERATION_ERROR_TITLE = exports.EDIT_OPEN_API_SPEC_BUTTON = exports.DECODE_CEF_LINK = exports.DATA_STREAM_TITLE_LABEL = exports.DATA_STREAM_TITLE = exports.DATA_STREAM_NAME_LABEL = exports.DATA_STREAM_DESCRIPTION_LABEL = exports.DATA_STREAM_DESCRIPTION = exports.DATA_COLLECTION_METHOD_LABEL = exports.ANALYZING = exports.ADD_OPEN_API_SPEC_OPTIONAL_LABEL = exports.ADD_OPEN_API_SPEC_LABEL = exports.ADD_OPEN_API_SPEC_DESCRIPTION = exports.ADD_OPEN_API_SPEC_BUTTON = void 0;
var _i18n = require("@kbn/i18n");
var _constants = require("../../../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const INTEGRATION_NAME_TITLE = exports.INTEGRATION_NAME_TITLE = _i18n.i18n.translate('xpack.automaticImport.step.dataStream.integrationNameTitle', {
  defaultMessage: 'Define package name'
});
const INTEGRATION_NAME_DESCRIPTION = exports.INTEGRATION_NAME_DESCRIPTION = _i18n.i18n.translate('xpack.automaticImport.step.dataStream.integrationNameDescription', {
  defaultMessage: "The package name is used to refer to the integration in Elastic's ingest pipeline"
});
const DATA_STREAM_TITLE = exports.DATA_STREAM_TITLE = _i18n.i18n.translate('xpack.automaticImport.step.dataStream.dataStreamTitle', {
  defaultMessage: 'Define data stream and upload logs'
});
const DATA_STREAM_DESCRIPTION = exports.DATA_STREAM_DESCRIPTION = _i18n.i18n.translate('xpack.automaticImport.step.dataStream.dataStreamDescription', {
  defaultMessage: 'Logs are analyzed to automatically map ECS fields and help create the ingestion pipeline'
});
const INTEGRATION_NAME_LABEL = exports.INTEGRATION_NAME_LABEL = _i18n.i18n.translate('xpack.automaticImport.step.dataStream.integrationName.label', {
  defaultMessage: 'Integration package name'
});
const NO_SPACES_HELP = exports.NO_SPACES_HELP = _i18n.i18n.translate('xpack.automaticImport.step.dataStream.noSpacesHelpText', {
  defaultMessage: 'Name must be at least 2 characters long, start with a letter, and can only contain lowercase letters, numbers, and underscores (_)'
});
const PACKAGE_NAMES_FETCH_ERROR = exports.PACKAGE_NAMES_FETCH_ERROR = _i18n.i18n.translate('xpack.automaticImport.step.dataStream.packageNamesFetchError', {
  defaultMessage: 'Error fetching package names'
});
const NAME_ALREADY_EXISTS_ERROR = exports.NAME_ALREADY_EXISTS_ERROR = _i18n.i18n.translate('xpack.automaticImport.step.dataStream.nameAlreadyExistsError', {
  defaultMessage: 'This integration name is already in use. Please choose a different name.'
});
const DATA_STREAM_TITLE_LABEL = exports.DATA_STREAM_TITLE_LABEL = _i18n.i18n.translate('xpack.automaticImport.step.dataStream.dataStreamTitle.label', {
  defaultMessage: 'Data stream title'
});
const DATA_STREAM_DESCRIPTION_LABEL = exports.DATA_STREAM_DESCRIPTION_LABEL = _i18n.i18n.translate('xpack.automaticImport.step.dataStream.dataStreamDescription.label', {
  defaultMessage: 'Data stream description'
});
const DATA_STREAM_NAME_LABEL = exports.DATA_STREAM_NAME_LABEL = _i18n.i18n.translate('xpack.automaticImport.step.dataStream.dataStreamName.label', {
  defaultMessage: 'Data stream name'
});
const DATA_COLLECTION_METHOD_LABEL = exports.DATA_COLLECTION_METHOD_LABEL = _i18n.i18n.translate('xpack.automaticImport.step.dataStream.dataCollectionMethod.label', {
  defaultMessage: 'Data collection method'
});
const ADD_OPEN_API_SPEC_LABEL = exports.ADD_OPEN_API_SPEC_LABEL = _i18n.i18n.translate('xpack.automaticImport.step.dataStream.addOpenApiSpecLabel', {
  defaultMessage: 'OpenAPI Spec'
});
const ADD_OPEN_API_SPEC_OPTIONAL_LABEL = exports.ADD_OPEN_API_SPEC_OPTIONAL_LABEL = _i18n.i18n.translate('xpack.automaticImport.step.dataStream.addOpenApiSpecOptionalLabel', {
  defaultMessage: 'Optional'
});
const ADD_OPEN_API_SPEC_BUTTON = exports.ADD_OPEN_API_SPEC_BUTTON = _i18n.i18n.translate('xpack.automaticImport.step.dataStream.addOpenApiSpecButton', {
  defaultMessage: 'Add OpenAPI spec file'
});
const OPEN_API_SPEC_BUTTON_CONFIGURED = exports.OPEN_API_SPEC_BUTTON_CONFIGURED = _i18n.i18n.translate('xpack.automaticImport.step.dataStream.openApiSpecButtonConfigured', {
  defaultMessage: 'OpenAPI spec file configured'
});
const EDIT_OPEN_API_SPEC_BUTTON = exports.EDIT_OPEN_API_SPEC_BUTTON = _i18n.i18n.translate('xpack.automaticImport.step.dataStream.editOpenApiSpecButton', {
  defaultMessage: 'Edit'
});
const ADD_OPEN_API_SPEC_DESCRIPTION = exports.ADD_OPEN_API_SPEC_DESCRIPTION = _i18n.i18n.translate('xpack.automaticImport.step.dataStream.addOpenApiSpecDescription', {
  defaultMessage: 'To successfully ingest data from an API, provide the associated OpenAPI Specification (OAS) file.'
});
const TECH_PREVIEW = exports.TECH_PREVIEW = _i18n.i18n.translate('xpack.automaticImport.step.dataStream.techPreviewBadge', {
  defaultMessage: 'Technical preview'
});
const TECH_PREVIEW_TOOLTIP = exports.TECH_PREVIEW_TOOLTIP = _i18n.i18n.translate('xpack.automaticImport.step.dataStream.techPreviewTooltip', {
  defaultMessage: 'This functionality is in technical preview and is subject to change. Please use with caution in production environments.'
});
const LOGS_SAMPLE_LABEL = exports.LOGS_SAMPLE_LABEL = _i18n.i18n.translate('xpack.automaticImport.step.dataStream.logsSample.label', {
  defaultMessage: 'Logs'
});
const LOGS_SAMPLE_WARNING = exports.LOGS_SAMPLE_WARNING = _i18n.i18n.translate('xpack.automaticImport.step.dataStream.logsSample.warning', {
  defaultMessage: 'Please note that this data will be analyzed by a third-party AI tool. Ensure that you comply with privacy and security guidelines when selecting data.'
});
const LOGS_SAMPLE_DESCRIPTION = exports.LOGS_SAMPLE_DESCRIPTION = _i18n.i18n.translate('xpack.automaticImport.step.dataStream.logsSample.description', {
  defaultMessage: 'Drag and drop a file or Browse files.'
});
const LOGS_SAMPLE_ERROR = exports.LOGS_SAMPLE_ERROR = {
  CAN_NOT_READ: _i18n.i18n.translate('xpack.automaticImport.step.dataStream.logsSample.errorCanNotRead', {
    defaultMessage: 'Failed to read the logs sample file'
  }),
  CAN_NOT_READ_WITH_REASON: reason => _i18n.i18n.translate('xpack.automaticImport.step.dataStream.logsSample.errorCanNotReadWithReason', {
    values: {
      reason
    },
    defaultMessage: 'An error occurred when reading logs sample: {reason}'
  }),
  CAN_NOT_PARSE: _i18n.i18n.translate('xpack.automaticImport.step.dataStream.logsSample.errorCanNotParse', {
    defaultMessage: 'Cannot parse the logs sample file as either a JSON or NDJSON file'
  }),
  TOO_LARGE_TO_PARSE: _i18n.i18n.translate('xpack.automaticImport.step.dataStream.logsSample.errorTooLargeToParse', {
    defaultMessage: 'This logs sample file is too large to parse'
  }),
  NOT_ARRAY: _i18n.i18n.translate('xpack.automaticImport.step.dataStream.logsSample.errorNotArray', {
    defaultMessage: 'The logs sample file is not an array'
  }),
  EMPTY: _i18n.i18n.translate('xpack.automaticImport.step.dataStream.logsSample.errorEmpty', {
    defaultMessage: 'The logs sample file is empty'
  }),
  NOT_OBJECT: _i18n.i18n.translate('xpack.automaticImport.step.dataStream.logsSample.errorNotObject', {
    defaultMessage: 'The logs sample file contains non-object entries'
  })
};
const ANALYZING = exports.ANALYZING = _i18n.i18n.translate('xpack.automaticImport.step.dataStream.analyzing', {
  defaultMessage: 'Analyzing'
});
const PROGRESS_ANALYZE_LOGS = exports.PROGRESS_ANALYZE_LOGS = _i18n.i18n.translate('xpack.automaticImport.step.dataStream.progress.analyzeLogs', {
  defaultMessage: 'Analyzing Sample logs'
});
const PROGRESS_ECS_MAPPING = exports.PROGRESS_ECS_MAPPING = _i18n.i18n.translate('xpack.automaticImport.step.dataStream.progress.ecsMapping', {
  defaultMessage: 'Mapping ECS fields'
});
const PROGRESS_CATEGORIZATION = exports.PROGRESS_CATEGORIZATION = _i18n.i18n.translate('xpack.automaticImport.step.dataStream.progress.categorization', {
  defaultMessage: 'Adding categorization'
});
const PROGRESS_RELATED_GRAPH = exports.PROGRESS_RELATED_GRAPH = _i18n.i18n.translate('xpack.automaticImport.step.dataStream.progress.relatedGraph', {
  defaultMessage: 'Generating related fields'
});
const GENERATION_ERROR_TITLE = progressStep => _i18n.i18n.translate('xpack.automaticImport.step.dataStream.generationError', {
  values: {
    progressStep
  },
  defaultMessage: 'An error occurred during: {progressStep}'
});
exports.GENERATION_ERROR_TITLE = GENERATION_ERROR_TITLE;
const RETRY = exports.RETRY = _i18n.i18n.translate('xpack.automaticImport.step.dataStream.retryButtonLabel', {
  defaultMessage: 'Retry'
});
const DECODE_CEF_LINK = exports.DECODE_CEF_LINK = _i18n.i18n.translate('xpack.automaticImport.errors.cefFormat.decodeLink', {
  defaultMessage: 'CEF format not supported yet. Instead please use CEF Integration:'
});
const GENERATION_ERROR_TRANSLATION = exports.GENERATION_ERROR_TRANSLATION = {
  [_constants.GenerationErrorCode.RECURSION_LIMIT_ANALYZE_LOGS]: _i18n.i18n.translate('xpack.automaticImport.errors.recursionLimitAnalyzeLogsErrorMessage', {
    defaultMessage: 'Please verify the format of log samples is correct and try again. Try with a fewer samples if error persists.'
  }),
  [_constants.GenerationErrorCode.RECURSION_LIMIT]: _i18n.i18n.translate('xpack.automaticImport.errors.recursionLimitReached', {
    defaultMessage: 'Max attempts exceeded. Please try again.'
  }),
  [_constants.GenerationErrorCode.UNSUPPORTED_LOG_SAMPLES_FORMAT]: attributes => {
    var _attributes$logFormat;
    if (attributes.logFormat !== undefined && ((_attributes$logFormat = attributes.logFormat) === null || _attributes$logFormat === void 0 ? void 0 : _attributes$logFormat.length) !== 0) {
      return _i18n.i18n.translate('xpack.automaticImport.errors.uparseableCSV.withReason', {
        values: {
          format: attributes.logFormat
        },
        defaultMessage: `Unsupported log format in the samples (format: {format}).`
      });
    } else {
      return _i18n.i18n.translate('xpack.automaticImport.errors.unsupportedLogSamples', {
        defaultMessage: `Unsupported log format in the samples.`
      });
    }
  },
  [_constants.GenerationErrorCode.CEF_ERROR]: _i18n.i18n.translate('xpack.automaticImport.errors.cefError', {
    // This is a default error message if the linking does not work.
    defaultMessage: 'CEF format detected. Please decode the CEF logs into JSON format using filebeat decode_cef processor.'
  }),
  [_constants.GenerationErrorCode.BUILD_INTEGRATION_ERROR]: _i18n.i18n.translate('xpack.automaticImport.errors.buildIntegrationError', {
    defaultMessage: 'An error occurred while building the integration package. Please try again.'
  }),
  [_constants.GenerationErrorCode.UNPARSEABLE_CSV_DATA]: attributes => {
    var _attributes$underlyin;
    if (attributes.underlyingMessages !== undefined && ((_attributes$underlyin = attributes.underlyingMessages) === null || _attributes$underlyin === void 0 ? void 0 : _attributes$underlyin.length) !== 0) {
      return _i18n.i18n.translate('xpack.automaticImport.errors.uparseableCSV.withReason', {
        values: {
          reason: attributes.underlyingMessages[0]
        },
        defaultMessage: `Cannot parse the samples as the CSV data (reason: {reason}). Please check the provided samples.`
      });
    } else {
      return _i18n.i18n.translate('xpack.automaticImport.errors.uparseableCSV.withoutReason', {
        defaultMessage: `Cannot parse the samples as the CSV data. Please check the provided samples.`
      });
    }
  }
};