"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Header = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _aiAssistantIcon = require("@kbn/ai-assistant-icon");
var _sharedUxPageKibanaTemplate = require("@kbn/shared-ux-page-kibana-template");
var _react2 = _interopRequireDefault(require("react"));
var _state = require("../state");
var _steps = require("./steps");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useAvatarCss = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return (0, _react.css)`
    border: 1px solid ${euiTheme.colors.lightShade};
    padding: ${euiTheme.size.xs};
  `;
};
const contentCss = (0, _react.css)`
  width: 100%;
  max-width: 730px;
`;
const Header = exports.Header = /*#__PURE__*/_react2.default.memo(({
  currentStep,
  isGenerating
}) => {
  const {
    setStep
  } = (0, _state.useActions)();
  const avatarCss = useAvatarCss();
  return /*#__PURE__*/_react2.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate.Header, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    alignItems: "center"
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    css: contentCss
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "l"
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    alignItems: "center",
    gutterSize: "s",
    justifyContent: "center"
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react2.default.createElement(_aiAssistantIcon.AssistantAvatar, {
    css: avatarCss,
    name: i18n.ASSISTANT_AVATAR
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react2.default.createElement("h1", null, /*#__PURE__*/_react2.default.createElement("span", null, i18n.TITLE)))))), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react2.default.createElement(_steps.Steps, {
    currentStep: currentStep,
    setStep: setStep,
    isGenerating: isGenerating
  }))))));
});
Header.displayName = 'Header';