"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getApmIndexSettings = getApmIndexSettings;
var _apm_indices = require("@kbn/apm-data-access-plugin/server/saved_objects/apm_indices");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getApmIndexSettings(resources) {
  const {
    apmIndicesFromConfigFile
  } = resources.plugins.apmDataAccess.setup;
  const soClient = (await resources.context.core).savedObjects.client;
  const apmIndicesSavedObject = await (0, _apm_indices.getApmIndicesSavedObject)(soClient);
  const apmIndicesKeys = Object.keys(apmIndicesFromConfigFile);
  return apmIndicesKeys.map(configurationName => ({
    configurationName,
    defaultValue: apmIndicesFromConfigFile[configurationName],
    // value defined in kibana[.dev].yml
    savedValue: apmIndicesSavedObject === null || apmIndicesSavedObject === void 0 ? void 0 : apmIndicesSavedObject[configurationName] // value saved via Saved Objects service
  }));
}