"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.alertingEsClient = alertingEsClient;
var _utils = require("@kbn/apm-data-access-plugin/server/utils");
var _ui_settings_keys = require("@kbn/observability-plugin/common/ui_settings_keys");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function alertingEsClient({
  scopedClusterClient,
  uiSettingsClient,
  params
}) {
  const excludedDataTiers = await uiSettingsClient.get(_ui_settings_keys.searchExcludedDataTiers);
  const response = await scopedClusterClient.asCurrentUser.search({
    ...params,
    body: {
      ...params.body,
      query: (0, _utils.getDataTierFilterCombined)({
        filter: params.body.query,
        excludedDataTiers
      })
    },
    ignore_unavailable: true
  });
  return response;
}