"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isApmSignal = isApmSignal;
exports.isLogsOnlySignal = isLogsOnlySignal;
exports.isLogsSignal = isLogsSignal;
var _common = require("@kbn/observability-shared-plugin/common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function isApmSignal(dataStreamTypes) {
  return dataStreamTypes.includes(_common.EntityDataStreamType.METRICS) || dataStreamTypes.includes(_common.EntityDataStreamType.TRACES);
}
function isLogsSignal(dataStreamTypes) {
  return dataStreamTypes.includes(_common.EntityDataStreamType.LOGS);
}
function isLogsOnlySignal(signalTypes) {
  return !isApmSignal(signalTypes) && isLogsSignal(signalTypes);
}