"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useServiceEntitySummaryFetcher = useServiceEntitySummaryFetcher;
var _use_entity_centric_experience_setting = require("../../hooks/use_entity_centric_experience_setting");
var _use_fetcher = require("../../hooks/use_fetcher");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useServiceEntitySummaryFetcher({
  serviceName,
  environment
}) {
  const {
    isEntityCentricExperienceEnabled
  } = (0, _use_entity_centric_experience_setting.useEntityCentricExperienceSetting)();
  const {
    data,
    status
  } = (0, _use_fetcher.useFetcher)(callAPI => {
    if (isEntityCentricExperienceEnabled && serviceName && environment) {
      return callAPI('GET /internal/apm/entities/services/{serviceName}/summary', {
        params: {
          path: {
            serviceName
          },
          query: {
            environment
          }
        }
      });
    }
  }, [environment, isEntityCentricExperienceEnabled, serviceName]);
  return {
    serviceEntitySummary: data,
    serviceEntitySummaryStatus: status
  };
}