"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StickyProperties = StickyProperties;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _style = require("../../../utils/style");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TooltipFieldName = _styled.default.span`
  font-family: ${({
  theme
}) => theme.euiTheme.font.familyCode};
`;
const PropertyLabel = _styled.default.div`
  margin-bottom: ${({
  theme
}) => theme.euiTheme.size.s};
  font-size: ${() => (0, _eui.useEuiFontSize)('xs').fontSize};
  color: ${({
  theme
}) => theme.euiTheme.colors.mediumShade};

  span {
    cursor: help;
  }
`;
PropertyLabel.displayName = 'PropertyLabel';
const propertyValueLineHeight = 1.2;
const PropertyValue = _styled.default.div`
  display: inline-block;
  line-height: ${propertyValueLineHeight};
`;
PropertyValue.displayName = 'PropertyValue';
const PropertyValueTruncated = _styled.default.span`
  display: inline-block;
  line-height: ${propertyValueLineHeight};
  ${(0, _style.truncate)('100%')};
`;
function getPropertyLabel({
  fieldName,
  label
}) {
  if (fieldName) {
    return /*#__PURE__*/_react.default.createElement(PropertyLabel, null, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: /*#__PURE__*/_react.default.createElement(TooltipFieldName, null, fieldName)
    }, /*#__PURE__*/_react.default.createElement("span", null, label)));
  }
  return /*#__PURE__*/_react.default.createElement(PropertyLabel, null, label);
}
function getPropertyValue({
  val,
  truncated = false
}) {
  if (truncated) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: String(val)
    }, /*#__PURE__*/_react.default.createElement(PropertyValueTruncated, null, String(val)));
  }
  return /*#__PURE__*/_react.default.createElement(PropertyValue, null, val);
}
function StickyProperties({
  stickyProperties
}) {
  /**
   * Note: the padding and margin styles here are strange because
   * EUI flex groups and items have a default "gutter" applied that
   * won't allow percentage widths to line up correctly, so we have
   * to turn the gutter off with gutterSize: none. When we do that,
   * the top/bottom spacing *also* collapses, so we have to add
   * padding between each item without adding it to the outside of
   * the flex group itself.
   *
   * Hopefully we can make EUI handle this better and remove all this.
   */
  const itemStyles = {
    padding: '1em 1em 1em 0'
  };
  const groupStyles = {
    marginTop: '-1em',
    marginBottom: '-1em'
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    wrap: true,
    gutterSize: "none",
    style: groupStyles
  }, stickyProperties && stickyProperties.map(({
    width = 0,
    ...prop
  }, i) => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      key: i,
      style: {
        minWidth: width,
        ...itemStyles
      },
      grow: false
    }, getPropertyLabel(prop), getPropertyValue(prop));
  }));
}