"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EnvironmentSelect = EnvironmentSelect;
var _lodash = require("lodash");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _environment_filter_values = require("../../../../common/environment_filter_values");
var _apm = require("../../../../common/es_fields/apm");
var _use_fetcher = require("../../../hooks/use_fetcher");
var _use_time_range = require("../../../hooks/use_time_range");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getEnvironmentOptions(environments) {
  const environmentOptions = environments.filter(env => env !== _environment_filter_values.ENVIRONMENT_NOT_DEFINED.value).map(environment => ({
    value: environment,
    label: environment
  }));
  return [_environment_filter_values.ENVIRONMENT_ALL, ...(environments.includes(_environment_filter_values.ENVIRONMENT_NOT_DEFINED.value) ? [_environment_filter_values.ENVIRONMENT_NOT_DEFINED] : []), ...environmentOptions];
}
function EnvironmentSelect({
  environment,
  availableEnvironments,
  status,
  serviceName,
  rangeFrom,
  rangeTo,
  onChange
}) {
  var _data$terms;
  const [searchValue, setSearchValue] = (0, _react.useState)('');
  const {
    start,
    end
  } = (0, _use_time_range.useTimeRange)({
    rangeFrom,
    rangeTo
  });
  const selectedOptions = [{
    value: environment,
    label: (0, _environment_filter_values.getEnvironmentLabel)(environment)
  }];
  const onSelect = changedOptions => {
    if (changedOptions.length === 1 && changedOptions[0].value) {
      onChange(changedOptions[0].value);
    }
  };
  const {
    data,
    status: searchStatus
  } = (0, _use_fetcher.useFetcher)(callApmApi => {
    return (0, _lodash.isEmpty)(searchValue) ? Promise.resolve({
      terms: []
    }) : callApmApi('GET /internal/apm/suggestions', {
      params: {
        query: {
          fieldName: _apm.SERVICE_ENVIRONMENT,
          fieldValue: searchValue,
          serviceName,
          start,
          end
        }
      }
    });
  }, [searchValue, start, end, serviceName]);
  const terms = (_data$terms = data === null || data === void 0 ? void 0 : data.terms) !== null && _data$terms !== void 0 ? _data$terms : [];
  const options = [...(searchValue === '' ? getEnvironmentOptions(availableEnvironments) : terms.map(name => {
    return {
      label: name,
      value: name
    };
  }))];
  const onSearch = (0, _react.useMemo)(() => (0, _lodash.debounce)(setSearchValue, 300), []);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    "data-test-subj": "environmentFilter",
    async: true,
    isClearable: false,
    style: {
      minWidth: '256px'
    },
    placeholder: _i18n.i18n.translate('xpack.apm.filter.environment.placeholder', {
      defaultMessage: 'Select environment'
    }),
    prepend: _i18n.i18n.translate('xpack.apm.filter.environment.label', {
      defaultMessage: 'Environment'
    }),
    singleSelection: {
      asPlainText: true
    },
    options: options,
    selectedOptions: selectedOptions,
    onChange: changedOptions => onSelect(changedOptions),
    onSearchChange: onSearch,
    isLoading: status === _use_fetcher.FETCH_STATUS.LOADING || searchStatus === _use_fetcher.FETCH_STATUS.LOADING
  });
}