"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LabsFlyout = LabsFlyout;
var _eui = require("@elastic/eui");
var _sharedUxUtility = require("@kbn/shared-ux-utility");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/observability-shared-plugin/public");
var _managementSettingsComponentsFieldRow = require("@kbn/management-settings-components-field-row");
var _use_apm_plugin_context = require("../../../../../context/apm_plugin/use_apm_plugin_context");
var _use_fetcher = require("../../../../../hooks/use_fetcher");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const LazyFieldRow = /*#__PURE__*/_react.default.lazy(async () => ({
  default: (await Promise.resolve().then(() => _interopRequireWildcard(require('@kbn/management-settings-components-field-row')))).FieldRow
}));
const FieldRow = (0, _sharedUxUtility.withSuspense)(LazyFieldRow);
function LabsFlyout({
  onClose
}) {
  const trackApmEvent = (0, _public.useUiTracker)({
    app: 'apm'
  });
  const {
    docLinks,
    notifications,
    application
  } = (0, _use_apm_plugin_context.useApmPluginContext)().core;
  const canSave = application.capabilities.advancedSettings.save && application.capabilities.apm['settings:save'];
  const {
    data,
    status
  } = (0, _use_fetcher.useFetcher)(callApmApi => callApmApi('GET /internal/apm/settings/labs'), []);
  const labsItems = (data === null || data === void 0 ? void 0 : data.labsItems) || [];
  const {
    fields,
    handleFieldChange,
    unsavedChanges,
    saveAll,
    isSaving,
    cleanUnsavedChanges
  } = (0, _public.useEditableSettings)(labsItems);
  async function handleSave() {
    try {
      const reloadPage = Object.keys(unsavedChanges).some(key => {
        return fields[key].requiresPageReload;
      });
      await saveAll();
      trackApmEvent({
        metric: 'labs_save'
      });
      if (reloadPage) {
        window.location.reload();
      } else {
        onClose();
      }
    } catch (e) {
      const error = e;
      notifications.toasts.addDanger({
        title: _i18n.i18n.translate('xpack.apm.apmSettings.save.error', {
          defaultMessage: 'An error occurred while saving the settings'
        }),
        text: error.message
      });
    }
  }
  function handelCancel() {
    cleanUnsavedChanges();
    onClose();
  }
  const isLoading = (0, _use_fetcher.isPending)(status);

  // We don't validate the user input on these settings
  const settingsValidationResponse = {
    successfulValidation: true,
    valid: true
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: onClose
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "beaker",
    size: "l"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.apm.labs', {
    defaultMessage: 'Labs'
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center",
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, _i18n.i18n.translate('xpack.apm.labs.description', {
    defaultMessage: 'Try out the APM features that are under technical preview and in progress.'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "labsFeedbackButton",
    href: "https://ela.st/feedback-apm-labs",
    target: "_blank",
    color: "warning",
    iconType: "editorComment"
  }, _i18n.i18n.translate('xpack.apm.labs.feedbackButtonLabel', {
    defaultMessage: 'Tell us what you think!'
  }))))), isLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
    lines: 3
  }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, labsItems.map(settingKey => {
    const field = fields[settingKey];
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_managementSettingsComponentsFieldRow.FieldRowProvider, {
      links: docLinks.links.management,
      showDanger: message => notifications.toasts.addDanger(message),
      validateChange: async () => settingsValidationResponse
    }, /*#__PURE__*/_react.default.createElement(FieldRow, {
      field: field,
      isSavingEnabled: canSave,
      onFieldChange: handleFieldChange,
      unsavedChange: unsavedChanges[settingKey]
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, null));
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "apmLabsFlyoutCancelButton",
    onClick: handelCancel
  }, _i18n.i18n.translate('xpack.apm.labs.cancel', {
    defaultMessage: 'Cancel'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: !canSave && _i18n.i18n.translate('xpack.apm.labs.noPermissionTooltipLabel', {
      defaultMessage: "Your user role doesn't have permissions to modify these settings"
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "apmLabsFlyoutReloadToApplyChangesButton",
    fill: true,
    isLoading: isSaving,
    onClick: handleSave,
    isDisabled: !canSave
  }, _i18n.i18n.translate('xpack.apm.labs.reload', {
    defaultMessage: 'Reload to apply changes'
  }))))))));
}