"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.aggregatedCriticalPathTab = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _use_apm_params = require("../../../hooks/use_apm_params");
var _use_time_range = require("../../../hooks/use_time_range");
var _critical_path_flamegraph = require("../../shared/critical_path_flamegraph");
var _technical_preview_badge = require("../../shared/technical_preview_badge");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function TransactionDetailAggregatedCriticalPath({
  traceSamplesFetchResult
}) {
  const {
    path: {
      serviceName
    },
    query: {
      rangeFrom,
      rangeTo,
      transactionName
    }
  } = (0, _use_apm_params.useAnyOfApmParams)('/services/{serviceName}/transactions/view', '/mobile-services/{serviceName}/transactions/view');
  const {
    start,
    end
  } = (0, _use_time_range.useTimeRange)({
    rangeFrom,
    rangeTo
  });
  const traceIds = (0, _react.useMemo)(() => {
    var _traceSamplesFetchRes, _traceSamplesFetchRes2;
    return (_traceSamplesFetchRes = (_traceSamplesFetchRes2 = traceSamplesFetchResult.data) === null || _traceSamplesFetchRes2 === void 0 ? void 0 : _traceSamplesFetchRes2.traceSamples.map(sample => sample.traceId)) !== null && _traceSamplesFetchRes !== void 0 ? _traceSamplesFetchRes : [];
  }, [traceSamplesFetchResult.data]);
  return /*#__PURE__*/_react.default.createElement(_critical_path_flamegraph.CriticalPathFlamegraph, {
    start: start,
    end: end,
    traceIdsFetchStatus: traceSamplesFetchResult.status,
    traceIds: traceIds,
    serviceName: serviceName,
    transactionName: transactionName
  });
}
const aggregatedCriticalPathTab = exports.aggregatedCriticalPathTab = {
  dataTestSubj: 'apmAggregatedCriticalPathTabButton',
  key: 'aggregatedCriticalPath',
  label: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    direction: "row"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, _i18n.i18n.translate('xpack.apm.transactionDetails.tabs.aggregatedCriticalPathLabel', {
    defaultMessage: 'Aggregated critical path'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_technical_preview_badge.TechnicalPreviewBadge, {
    icon: "beaker",
    size: "s",
    style: {
      verticalAlign: 'middle'
    }
  }))),
  component: TransactionDetailAggregatedCriticalPath
};