"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ALERT_STATUS_ALL = void 0;
exports.AlertsOverview = AlertsOverview;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _public = require("@kbn/observability-plugin/public");
var _eui = require("@elastic/eui");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _public2 = require("@kbn/kibana-react-plugin/public");
var _apm_alerting_feature_ids = require("../../../../common/alerting/config/apm_alerting_feature_ids");
var _use_apm_params = require("../../../hooks/use_apm_params");
var _apm = require("../../../../common/es_fields/apm");
var _environment_filter_values = require("../../../../common/environment_filter_values");
var _url_helpers = require("../../shared/links/url_helpers");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ALERT_STATUS_ALL = exports.ALERT_STATUS_ALL = 'all';
function AlertsOverview() {
  const history = (0, _reactRouterDom.useHistory)();
  const {
    path: {
      serviceName
    },
    query: {
      environment,
      rangeFrom,
      rangeTo,
      kuery,
      alertStatus
    }
  } = (0, _use_apm_params.useAnyOfApmParams)('/services/{serviceName}/alerts', '/mobile-services/{serviceName}/alerts');
  const {
    services
  } = (0, _public2.useKibana)();
  const [alertStatusFilter, setAlertStatusFilter] = (0, _react.useState)(ALERT_STATUS_ALL);
  const [esQuery, setEsQuery] = (0, _react.useState)();
  (0, _react.useEffect)(() => {
    if (alertStatus) {
      setAlertStatusFilter(alertStatus);
    }
  }, [alertStatus]);
  const {
    triggersActionsUi: {
      getAlertsStateTable: AlertsStateTable,
      getAlertsSearchBar: AlertsSearchBar,
      alertsTableConfigurationRegistry
    },
    notifications,
    data: {
      query: {
        timefilter: {
          timefilter: timeFilterService
        }
      }
    },
    uiSettings,
    observability: {
      observabilityRuleTypeRegistry
    }
  } = services;
  const useToasts = () => notifications.toasts;
  const apmQueries = (0, _react.useMemo)(() => {
    const environmentKuery = (0, _environment_filter_values.getEnvironmentKuery)(environment);
    let query = `${_apm.SERVICE_NAME}:${serviceName}`;
    if (environmentKuery) {
      query += ` AND ${environmentKuery}`;
    }
    return [{
      query,
      language: 'kuery'
    }];
  }, [serviceName, environment]);
  const onKueryChange = (0, _react.useCallback)(value => (0, _url_helpers.push)(history, {
    query: {
      kuery: value
    }
  }), [history]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    borderRadius: "none",
    hasShadow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_public.ObservabilityAlertSearchBar, {
    appName: 'apmApp',
    kuery: kuery,
    onRangeFromChange: value => (0, _url_helpers.push)(history, {
      query: {
        rangeFrom: value
      }
    }),
    onRangeToChange: value => (0, _url_helpers.push)(history, {
      query: {
        rangeTo: value
      }
    }),
    onKueryChange: onKueryChange,
    defaultSearchQueries: apmQueries,
    onStatusChange: setAlertStatusFilter,
    onEsQueryChange: setEsQuery,
    rangeTo: rangeTo,
    rangeFrom: rangeFrom,
    status: alertStatusFilter,
    services: {
      timeFilterService,
      AlertsSearchBar,
      useToasts,
      uiSettings
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, esQuery && /*#__PURE__*/_react.default.createElement(AlertsStateTable, {
    alertsTableConfigurationRegistry: alertsTableConfigurationRegistry,
    id: 'service-overview-alerts',
    configurationId: _ruleDataUtils.AlertConsumers.OBSERVABILITY,
    ruleTypeIds: _apm_alerting_feature_ids.APM_ALERTING_RULE_TYPE_IDS,
    consumers: _apm_alerting_feature_ids.APM_ALERTING_CONSUMERS,
    query: esQuery,
    showAlertStatusWithFlapping: true,
    cellContext: {
      observabilityRuleTypeRegistry
    }
  }))));
}