"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFindMaintenanceWindows = void 0;
var _i18n = require("@kbn/i18n");
var _reactQuery = require("@tanstack/react-query");
var _kibana_react = require("../utils/kibana_react");
var _find = require("../services/maintenance_windows_api/find");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useFindMaintenanceWindows = params => {
  const {
    enabled = true,
    page,
    perPage,
    search,
    selectedStatus
  } = params;
  const {
    http,
    notifications: {
      toasts
    }
  } = (0, _kibana_react.useKibana)().services;
  const queryFn = () => {
    return (0, _find.findMaintenanceWindows)({
      http,
      page,
      perPage,
      search,
      selectedStatus
    });
  };
  const onErrorFn = error => {
    if (error) {
      toasts.addDanger(_i18n.i18n.translate('xpack.alerting.maintenanceWindowsListFailure', {
        defaultMessage: 'Unable to load maintenance windows.'
      }));
    }
  };
  const queryKey = ['findMaintenanceWindows', page, perPage, search, selectedStatus];
  const {
    isLoading,
    isFetching,
    isInitialLoading,
    data,
    refetch
  } = (0, _reactQuery.useQuery)({
    queryKey,
    queryFn,
    onError: onErrorFn,
    refetchOnWindowFocus: false,
    retry: false,
    cacheTime: 0,
    enabled,
    placeholderData: {
      maintenanceWindows: [],
      total: 0
    },
    keepPreviousData: true
  });
  return {
    data,
    isLoading: enabled && (isLoading || isFetching),
    isInitialLoading,
    refetch
  };
};
exports.useFindMaintenanceWindows = useFindMaintenanceWindows;