"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateParamsSchema = exports.updateBodySchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _shared = require("../../../shared");
var _r_rule = require("../../../../r_rule");
var _alerts_filter_query = require("../../../../alerts_filter_query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const updateParamsSchema = exports.updateParamsSchema = _configSchema.schema.object({
  id: _configSchema.schema.string()
});
const updateBodySchema = exports.updateBodySchema = _configSchema.schema.object({
  title: _configSchema.schema.maybe(_configSchema.schema.string()),
  enabled: _configSchema.schema.maybe(_configSchema.schema.boolean()),
  duration: _configSchema.schema.maybe(_configSchema.schema.number()),
  r_rule: _configSchema.schema.maybe(_r_rule.rRuleRequestSchemaV1),
  category_ids: _shared.maintenanceWindowCategoryIdsSchemaV1,
  scoped_query: _configSchema.schema.maybe(_configSchema.schema.nullable(_alerts_filter_query.alertsFilterQuerySchemaV1))
});