"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InformationText = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const InformationText = ({
  eventRateLength,
  fields,
  categoriesLength,
  loading
}) => {
  if (loading === true) {
    return null;
  }
  if ((fields === null || fields === void 0 ? void 0 : fields.length) === 0) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      title: /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.aiops.logCategorization.noTextFieldsTitle",
        defaultMessage: "No text fields found"
      })),
      titleSize: "xs",
      body: /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.aiops.logCategorization.noTextFieldsBody",
        defaultMessage: "Pattern analysis can only be run on text fields."
      })),
      "data-test-subj": "aiopsNoTextFieldsEmptyPrompt"
    });
  }
  if (eventRateLength === 0) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      title: /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.aiops.logCategorization.noDocsTitle",
        defaultMessage: "No documents found"
      })),
      titleSize: "xs",
      body: /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.aiops.logCategorization.noDocsBody",
        defaultMessage: "Ensure the selected time range contains documents."
      })),
      "data-test-subj": "aiopsNoDocsEmptyPrompt"
    });
  }
  if (eventRateLength > 0 && categoriesLength === null) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      title: /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.aiops.logCategorization.emptyPromptTitle",
        defaultMessage: "Select a text field and click run pattern analysis to start analysis"
      })),
      titleSize: "xs",
      body: /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.aiops.logCategorization.emptyPromptBody",
        defaultMessage: "Log pattern analysis groups messages into common patterns."
      })),
      "data-test-subj": "aiopsNoWindowParametersEmptyPrompt"
    });
  }
  if (eventRateLength > 0 && categoriesLength !== null && categoriesLength === 0) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      title: /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.aiops.logCategorization.noCategoriesTitle",
        defaultMessage: "No patterns found"
      })),
      titleSize: "xs",
      body: /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.aiops.logCategorization.noCategoriesBody",
        defaultMessage: "Ensure the selected field is populated in the selected time range."
      })),
      "data-test-subj": "aiopsNoCategoriesEmptyPrompt"
    });
  }
  return null;
};
exports.InformationText = InformationText;