"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setStickyHistogram = exports.setIsBrushCleared = exports.setInitialAnalysisStart = exports.setGroupResults = exports.setDocumentCountChartData = exports.setChartWindowParameters = exports.setAutoRunAnalysis = exports.setAnalysisType = exports.logRateAnalysisSlice = exports.clearSelection = exports.brushSelectionUpdate = void 0;
var _toolkit = require("@reduxjs/toolkit");
var _log_rate_analysis_type = require("../log_rate_analysis_type");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Payload for brushSelectionUpdate action
 */

function getDefaultState() {
  return {
    analysisType: _log_rate_analysis_type.LOG_RATE_ANALYSIS_TYPE.SPIKE,
    autoRunAnalysis: true,
    initialAnalysisStart: undefined,
    isBrushCleared: true,
    groupResults: false,
    documentStats: {
      sampleProbability: 1,
      totalCount: 0
    },
    // Default to false for now, until page restructure work to enable smooth sticky histogram is done
    stickyHistogram: false
  };
}
const logRateAnalysisSlice = exports.logRateAnalysisSlice = (0, _toolkit.createSlice)({
  name: 'logRateAnalysis',
  initialState: getDefaultState(),
  reducers: {
    brushSelectionUpdate: (state, action) => {
      if (!state.isBrushCleared || action.payload.force) {
        state.chartWindowParameters = action.payload.windowParameters;
      }
      if (action.payload.force) {
        state.isBrushCleared = false;
      }
      state.analysisType = action.payload.analysisType;
    },
    clearSelection: state => {
      state.chartWindowParameters = undefined;
      state.isBrushCleared = true;
      state.initialAnalysisStart = undefined;
    },
    setAnalysisType: (state, action) => {
      state.analysisType = action.payload;
    },
    setAutoRunAnalysis: (state, action) => {
      state.autoRunAnalysis = action.payload;
    },
    setDocumentCountChartData: (state, action) => {
      state.earliest = action.payload.earliest;
      state.latest = action.payload.latest;
      state.intervalMs = action.payload.intervalMs;
      state.documentStats = action.payload.documentStats;
    },
    setGroupResults: (state, action) => {
      state.groupResults = action.payload;
    },
    setInitialAnalysisStart: (state, action) => {
      state.initialAnalysisStart = action.payload;
    },
    setIsBrushCleared: (state, action) => {
      state.isBrushCleared = action.payload;
    },
    setStickyHistogram: (state, action) => {
      state.stickyHistogram = action.payload;
    },
    setChartWindowParameters: (state, action) => {
      state.chartWindowParameters = action.payload;
      state.isBrushCleared = action.payload === undefined;
    }
  }
});

// Action creators are generated for each case reducer function
const {
  brushSelectionUpdate,
  clearSelection,
  setAnalysisType,
  setAutoRunAnalysis,
  setDocumentCountChartData,
  setGroupResults,
  setInitialAnalysisStart,
  setIsBrushCleared,
  setStickyHistogram,
  setChartWindowParameters
} = logRateAnalysisSlice.actions;
exports.setChartWindowParameters = setChartWindowParameters;
exports.setStickyHistogram = setStickyHistogram;
exports.setIsBrushCleared = setIsBrushCleared;
exports.setInitialAnalysisStart = setInitialAnalysisStart;
exports.setGroupResults = setGroupResults;
exports.setDocumentCountChartData = setDocumentCountChartData;
exports.setAutoRunAnalysis = setAutoRunAnalysis;
exports.setAnalysisType = setAnalysisType;
exports.clearSelection = clearSelection;
exports.brushSelectionUpdate = brushSelectionUpdate;