"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const commander_1 = require("commander");
const convert_1 = require("./convert");
async function main() {
    const program = new commander_1.Command();
    program
        .name("request-converter")
        .description("Convert Elasticsearch Dev Console scripts to other languages")
        .addOption(new commander_1.Option("-f, --format <format>", "export format")
        .choices((0, convert_1.listFormats)())
        .makeOptionMandatory())
        .option("--complete", "output complete code that includes the creation of the client", false)
        .option("--elasticsearch-url", "Elasticsearch endpoint URL. Only needed when --complete is given.", "http://localhost:9200")
        .option("--print-response", "add code to print the response(s)", false)
        .option("--debug", "output information useful when debugging", false);
    program.parse();
    const opts = program.opts();
    let data = "";
    for await (const chunk of process.stdin) {
        data += chunk;
    }
    const code = (await (0, convert_1.convertRequests)(data, opts.format, {
        complete: opts.complete,
        elasticsearchUrl: opts.elasticsearchUrl,
        debug: opts.debug,
        printResponse: opts.printResponse,
    }));
    process.stdout.write(code);
}
main();
