"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiPageHeaderContentStyles = void 0;
var _react = require("@emotion/react");
var _global_styling = require("../../../global_styling");
function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var _ref = process.env.NODE_ENV === "production" ? {
  name: "1574q9m-euiPageHeaderContent__top",
  styles: "container-type:inline-size;label:euiPageHeaderContent__top;"
} : {
  name: "1574q9m-euiPageHeaderContent__top",
  styles: "container-type:inline-size;label:euiPageHeaderContent__top;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var _ref2 = process.env.NODE_ENV === "production" ? {
  name: "1ajq27l-responsiveReverse",
  styles: "flex-direction:column-reverse;align-items:flex-start;label:responsiveReverse;"
} : {
  name: "1ajq27l-responsiveReverse",
  styles: "flex-direction:column-reverse;align-items:flex-start;label:responsiveReverse;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var _ref3 = process.env.NODE_ENV === "production" ? {
  name: "177mkz8-responsive",
  styles: "flex-direction:column;align-items:flex-start;label:responsive;"
} : {
  name: "177mkz8-responsive",
  styles: "flex-direction:column;align-items:flex-start;label:responsive;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var _ref4 = process.env.NODE_ENV === "production" ? {
  name: "1uwc4oj-stretch",
  styles: "align-items:stretch;label:stretch;"
} : {
  name: "1uwc4oj-stretch",
  styles: "align-items:stretch;label:stretch;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var _ref5 = process.env.NODE_ENV === "production" ? {
  name: "8391db-center",
  styles: "align-items:center;label:center;"
} : {
  name: "8391db-center",
  styles: "align-items:center;label:center;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var _ref6 = process.env.NODE_ENV === "production" ? {
  name: "1msaet2-bottom",
  styles: "align-items:flex-end;label:bottom;"
} : {
  name: "1msaet2-bottom",
  styles: "align-items:flex-end;label:bottom;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var _ref7 = process.env.NODE_ENV === "production" ? {
  name: "1gnwbvd-top",
  styles: "align-items:flex-start;label:top;"
} : {
  name: "1gnwbvd-top",
  styles: "align-items:flex-start;label:top;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var euiPageHeaderContentStyles = exports.euiPageHeaderContentStyles = function euiPageHeaderContentStyles(_ref8) {
  var euiTheme = _ref8.euiTheme;
  return {
    euiPageHeaderContent: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('width', '100%'), " ", (0, _global_styling.logicalCSS)('margin-horizontal', 'auto'), ";;label:euiPageHeaderContent;"),
    // alignItems
    top: _ref7,
    bottom: _ref6,
    center: _ref5,
    stretch: _ref4,
    // Children only (legacy) expects EuiPageHeaderSections as children
    childrenOnly: {
      flex: /*#__PURE__*/(0, _react.css)("flex-direction:row;display:flex;gap:", euiTheme.size.base, ";justify-content:space-between;;label:flex;"),
      // Responsive (what to do at the smaller breakpoint)
      responsive: _ref3,
      responsiveReverse: _ref2
    },
    euiPageHeaderContent__top: _ref,
    euiPageHeaderContent__leftSideItems: /*#__PURE__*/(0, _react.css)("@container (max-width: ", euiTheme.breakpoint.m, "px){", (0, _global_styling.logicalCSS)('min-width', '50%'), ";};label:euiPageHeaderContent__leftSideItems;"),
    euiPageHeaderContent__rightSideItems: /*#__PURE__*/(0, _react.css)("flex:0 1 auto;align-content:flex-start;", (0, _global_styling.logicalCSS)('max-width', '100%'), "@container (min-width: ", euiTheme.breakpoint.m, "px){", (0, _global_styling.logicalCSS)('max-width', '50%'), " justify-content:flex-end;};label:euiPageHeaderContent__rightSideItems;"),
    euiPageHeaderContent__rightSideItem: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('max-width', '100%'), ";;label:euiPageHeaderContent__rightSideItem;"),
    euiPageHeaderContent__titleIcon: /*#__PURE__*/(0, _react.css)("position:relative;", (0, _global_styling.logicalCSS)('top', "-".concat(euiTheme.size.xs)), " ", (0, _global_styling.logicalCSS)('margin-right', euiTheme.size.base), ";;label:euiPageHeaderContent__titleIcon;")
  };
};