"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiFormRowStyles = void 0;
var _react = require("@emotion/react");
var _global_styling = require("../../../global_styling");
var _form = require("../form.styles");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

var euiFormRowStyles = exports.euiFormRowStyles = function euiFormRowStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var _euiFormVariables = (0, _form.euiFormVariables)(euiThemeContext),
    maxWidth = _euiFormVariables.maxWidth,
    controlHeight = _euiFormVariables.controlHeight,
    controlCompressedHeight = _euiFormVariables.controlCompressedHeight;
  return {
    euiFormRow: /*#__PURE__*/(0, _react.css)("display:flex;+.euiButton{", (0, _global_styling.logicalCSS)('margin-top', euiTheme.size.base), ";};label:euiFormRow;"),
    // Skip css`` to avoid generating an Emotion className
    formWidth: "\n      ".concat((0, _global_styling.logicalCSS)('max-width', maxWidth), "\n    "),
    fullWidth: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('max-width', '100%'), ";;label:fullWidth;"),
    // Skip css`` to avoid generating an extra className
    row: "\n      flex-direction: column;\n      row-gap: ".concat(euiTheme.size.xs, ";\n\n      .euiFormRow__labelWrapper {\n        display: flex;\n        flex-wrap: wrap;\n        justify-content: space-between;\n      }\n\n      + .euiFormRow {\n        ").concat((0, _global_styling.logicalCSS)('margin-top', euiTheme.size.base), "\n      }\n    "),
    // No difference from the uncompressed row for the current EUI theme
    get rowCompressed() {
      return this.row;
    },
    columnCompressed: /*#__PURE__*/(0, _react.css)("flex-direction:row;align-items:stretch;column-gap:", euiTheme.size.s, ";.euiFormRow__label{hyphens:auto;}.euiFormRow__labelWrapper{flex-basis:calc(33% - ", euiTheme.size.s, ");", (0, _global_styling.logicalCSS)('min-width', 0), " line-height:", controlCompressedHeight, ";}.euiFormRow__fieldWrapper{flex-basis:67%;", (0, _global_styling.logicalCSS)('min-width', 0), ";}+.euiFormRow{", (0, _global_styling.logicalCSS)('margin-top', euiTheme.size.s), ";}&:has(.euiSwitch){&:not(:first-child){", (0, _global_styling.logicalCSS)('margin-top', euiTheme.size.m), ";}&:not(:last-child){", (0, _global_styling.logicalCSS)('margin-bottom', euiTheme.size.m), ";}.euiFormRow__labelWrapper{line-height:", euiTheme.size.base, ";}};label:columnCompressed;"),
    // Center display is primarily for inline form rows, which may have have
    // field content that is shorter than form controls (e.g. switches, text),
    // and should vertically center said content
    centerDisplayCss: function centerDisplayCss(compressed) {
      return "\n      .euiFormRow__fieldWrapper {\n        display: flex;\n        align-items: center;\n        ".concat((0, _global_styling.logicalCSS)('min-height', compressed ? controlCompressedHeight : controlHeight), "\n      }\n    ");
    },
    get center() {
      return /*#__PURE__*/(0, _react.css)(this.row, " ", this.centerDisplayCss(false), ";;label:center;");
    },
    get centerCompressed() {
      return /*#__PURE__*/(0, _react.css)(this.row, " ", this.centerDisplayCss(true), ";;label:centerCompressed;");
    }
  };
};