"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiComboBoxPillStyles = void 0;
var _react = require("@emotion/react");
var _global_styling = require("../../../global_styling");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

var euiComboBoxPillStyles = exports.euiComboBoxPillStyles = function euiComboBoxPillStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;

  // Ensure the input doesn't drop to the next line when the EuiBadge has a very long text
  var pillMaxWidth = "calc(100% - ".concat(euiTheme.size.xxs, " - ").concat(euiTheme.size.base, ")");
  var pillHeight = (0, _global_styling.mathWithUnits)(euiTheme.size.l, function (x) {
    return x - 2;
  });
  var pillLineHeight = (0, _global_styling.mathWithUnits)(pillHeight, function (x) {
    return x - 2;
  });
  return {
    euiComboBoxPill: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('max-width', pillMaxWidth), " ", (0, _global_styling.logicalCSS)('height', pillHeight), " line-height:", pillLineHeight, ";vertical-align:baseline;", (0, _global_styling.logicalCSS)('margin-vertical', '1px'), "&+.euiBadge{", (0, _global_styling.logicalCSS)('margin-left', 0), ";}.euiBadge__text{display:flex;align-items:center;.euiIcon{display:block;}};label:euiComboBoxPill;")
  };
};