"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.renderAreas = renderAreas;
const panel_clipping_1 = require("./panel_clipping");
const points_1 = require("./points");
const path_1 = require("./primitives/path");
const area_1 = require("./styles/area");
const line_1 = require("./styles/line");
const panel_transform_1 = require("./utils/panel_transform");
const color_library_wrappers_1 = require("../../../../common/color_library_wrappers");
const canvas_1 = require("../../../../renderers/canvas");
const common_1 = require("../../../../utils/common");
const utils_1 = require("../../rendering/utils");
const texture_1 = require("../../utils/texture");
function renderAreas(ctx, imgCanvas, areas, sharedStyle, rotation, renderingArea, highlightedLegendItem) {
    (0, canvas_1.withContext)(ctx, () => {
        areas.forEach(({ panel, value: geom }) => {
            const clippings = (0, panel_clipping_1.getPanelClipping)(panel, rotation);
            if (geom.style.area.visible) {
                (0, panel_transform_1.withPanelTransform)(ctx, panel, rotation, renderingArea, () => renderArea(ctx, imgCanvas, geom, sharedStyle, clippings, highlightedLegendItem), { area: clippings, shouldClip: true });
            }
            if (geom.style.line.visible) {
                (0, panel_transform_1.withPanelTransform)(ctx, panel, rotation, renderingArea, () => renderAreaLines(ctx, geom, sharedStyle, clippings, highlightedLegendItem), { area: clippings, shouldClip: true });
            }
        });
        areas.forEach(({ panel, value: { style, seriesIdentifier, points, hasFit, minPointDistance } }) => {
            const geometryStyle = (0, utils_1.getGeometryStateStyle)(seriesIdentifier, sharedStyle, highlightedLegendItem);
            (0, panel_transform_1.withPanelTransform)(ctx, panel, rotation, renderingArea, () => (0, points_1.renderPoints)(ctx, points, geometryStyle, style.point, style.line.strokeWidth, minPointDistance, style.pointVisibilityMinDistance, hasFit && points.length > 1), { area: (0, panel_clipping_1.getPanelClipping)(panel, rotation), shouldClip: points[0]?.value.mark !== null });
        });
    });
}
function renderArea(ctx, imgCanvas, geometry, sharedStyle, clippings, highlightedLegendItem) {
    const { area, color, transform, seriesIdentifier, style, clippedRanges, shouldClip } = geometry;
    const geometryStateStyle = (0, utils_1.getGeometryStateStyle)(seriesIdentifier, sharedStyle, highlightedLegendItem);
    const areaFill = (0, area_1.buildAreaStyles)(ctx, imgCanvas, color, style.area, geometryStateStyle);
    const fitAreaFillColor = style.fit.area.fill === common_1.ColorVariant.Series ? color : style.fit.area.fill;
    const fitAreaFill = {
        texture: (0, texture_1.getTextureStyles)(ctx, imgCanvas, fitAreaFillColor, geometryStateStyle.opacity, style.fit.area.texture),
        color: (0, color_library_wrappers_1.overrideOpacity)((0, color_library_wrappers_1.colorToRgba)(fitAreaFillColor), (opacity) => opacity * geometryStateStyle.opacity * style.fit.area.opacity),
    };
    (0, path_1.renderAreaPath)(ctx, transform, area, areaFill, fitAreaFill, clippedRanges, clippings, shouldClip && style.fit.area.visible);
}
function renderAreaLines(ctx, geometry, sharedStyle, clippings, highlightedLegendItem) {
    const { lines, color, seriesIdentifier, transform, style, clippedRanges, shouldClip } = geometry;
    const geometryStateStyle = (0, utils_1.getGeometryStateStyle)(seriesIdentifier, sharedStyle, highlightedLegendItem);
    const lineStyle = (0, line_1.buildLineStyles)(color, style.line, geometryStateStyle);
    const fitLineStroke = {
        dash: style.fit.line.dash,
        width: style.line.strokeWidth,
        color: (0, color_library_wrappers_1.overrideOpacity)((0, color_library_wrappers_1.colorToRgba)(style.fit.line.stroke === common_1.ColorVariant.Series ? color : style.fit.line.stroke), (opacity) => opacity * geometryStateStyle.opacity * style.fit.line.opacity),
    };
    (0, path_1.renderLinePaths)(ctx, transform, lines, lineStyle, fitLineStroke, clippedRanges, clippings, shouldClip && style.fit.line.visible);
}
//# sourceMappingURL=areas.js.map