"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.zeroTouch = exports.twoTouchPinch = exports.getPinchRatio = exports.eraseMultitouch = exports.setNewMultitouch = exports.continuedTwoPointTouch = exports.touches = exports.touchMidpoint = exports.initialMultitouch = void 0;
const initialMultitouch = () => [];
exports.initialMultitouch = initialMultitouch;
const touchMidpoint = (multitouch) => multitouch.reduce((sum, { position }) => sum + position, 0) / multitouch.length;
exports.touchMidpoint = touchMidpoint;
const isNonNull = (thing) => thing !== null;
const touches = (e) => [...new Array(e.touches?.length ?? 0)]
    .map((_, i) => e.touches.item(i))
    .filter(isNonNull)
    .map((t) => ({ id: t.identifier, position: t.clientX }))
    .sort(({ position: a }, { position: b }) => a - b);
exports.touches = touches;
const continuedTwoPointTouch = (multitouch, newMultitouch) => [...newMultitouch, ...multitouch].filter((t, i, a) => a.findIndex((tt) => tt.id === t.id) === i).length === 2;
exports.continuedTwoPointTouch = continuedTwoPointTouch;
const setNewMultitouch = (multitouch, newMultitouch) => multitouch.splice(0, Infinity, ...newMultitouch);
exports.setNewMultitouch = setNewMultitouch;
const eraseMultitouch = (multitouch) => multitouch.splice(0, Infinity);
exports.eraseMultitouch = eraseMultitouch;
const getPinchRatio = (multitouch, newMultitouch) => {
    return ((multitouch[1]?.position ?? NaN - (multitouch[0]?.position ?? NaN)) /
        ((newMultitouch[1]?.position ?? NaN) - (newMultitouch[0]?.position ?? NaN)));
};
exports.getPinchRatio = getPinchRatio;
const twoTouchPinch = (multitouch) => multitouch.length === 2;
exports.twoTouchPinch = twoTouchPinch;
const zeroTouch = (multitouch) => multitouch.length === 0;
exports.zeroTouch = zeroTouch;
//# sourceMappingURL=multitouch.js.map