"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.TimeslipWithTooltip = void 0;
const react_1 = __importDefault(require("react"));
const react_redux_1 = require("react-redux");
const redux_1 = require("redux");
const timeslip_render_1 = require("./timeslip/timeslip_render");
const __1 = require("..");
const constants_1 = require("../../common/constants");
const specs_1 = require("../../specs");
const spec_type_1 = require("../../specs/spec_type");
const chart_1 = require("../../state/actions/chart");
const get_accessibility_config_1 = require("../../state/selectors/get_accessibility_config");
const get_settings_spec_1 = require("../../state/selectors/get_settings_spec");
const get_tooltip_spec_1 = require("../../state/selectors/get_tooltip_spec");
const get_specs_from_store_1 = require("../../state/utils/get_specs_from_store");
const common_1 = require("../flame_chart/render/common");
class TimeslipComponent extends react_1.default.Component {
    static displayName = 'Timeslip';
    ctx = null;
    componentDidMount = () => {
        this.tryCanvasContext();
        this.drawCanvas();
        this.props.onChartRendered();
        this.props.containerRef().current?.addEventListener('wheel', (e) => e.preventDefault(), { passive: false });
        const canvas = this.props.forwardStageRef.current;
        if (canvas && this.ctx)
            (0, timeslip_render_1.timeslipRender)(canvas, this.ctx, this.props.getData);
    };
    componentWillUnmount() {
        this.props.containerRef().current?.removeEventListener('wheel', (e) => e.preventDefault());
    }
    componentDidUpdate = () => {
        if (!this.ctx)
            this.tryCanvasContext();
    };
    render = () => {
        const { forwardStageRef, chartDimensions: { width: requestedWidth, height: requestedHeight }, a11ySettings, } = this.props;
        const width = (0, common_1.roundUpSize)(requestedWidth);
        const height = (0, common_1.roundUpSize)(requestedHeight);
        const style = {
            width,
            height,
            top: 0,
            left: 0,
            padding: 0,
            margin: 0,
            border: 0,
            position: 'absolute',
            cursor: constants_1.DEFAULT_CSS_CURSOR,
            touchAction: 'none',
        };
        const dpr = window.devicePixelRatio;
        const canvasWidth = width * dpr;
        const canvasHeight = height * dpr;
        return (react_1.default.createElement(react_1.default.Fragment, null,
            react_1.default.createElement("figure", { "aria-labelledby": a11ySettings.labelId, "aria-describedby": a11ySettings.descriptionId },
                react_1.default.createElement("canvas", { ref: forwardStageRef, tabIndex: 0, className: "echCanvasRenderer", width: canvasWidth, height: canvasHeight, style: { ...style, outline: 'none' }, role: "presentation" }))));
    };
    drawCanvas = () => {
        if (!this.ctx)
            return;
        this.props.onRenderChange(true);
    };
    tryCanvasContext = () => {
        const canvas = this.props.forwardStageRef.current;
        this.ctx = canvas && canvas.getContext('2d');
    };
}
const mapStateToProps = (state) => {
    const timeslipSpec = (0, get_specs_from_store_1.getSpecsFromStore)(state.specs, __1.ChartType.Timeslip, spec_type_1.SpecType.Series)[0];
    const settingsSpec = (0, get_settings_spec_1.getSettingsSpecSelector)(state);
    return {
        getData: timeslipSpec?.getData ?? (() => []),
        chartDimensions: state.parentDimensions,
        a11ySettings: (0, get_accessibility_config_1.getA11ySettingsSelector)(state),
        tooltipRequired: (0, get_tooltip_spec_1.getTooltipSpecSelector)(state).type !== specs_1.TooltipType.None,
        onElementOver: settingsSpec.onElementOver ?? (() => { }),
        onElementClick: settingsSpec.onElementClick ?? (() => { }),
        onElementOut: settingsSpec.onElementOut ?? (() => { }),
        onRenderChange: settingsSpec.onRenderChange ?? (() => { }),
    };
};
const mapDispatchToProps = (dispatch) => (0, redux_1.bindActionCreators)({
    onChartRendered: chart_1.onChartRendered,
}, dispatch);
const TimeslipChartLayers = (0, react_redux_1.connect)(mapStateToProps, mapDispatchToProps)(TimeslipComponent);
const TimeslipWithTooltip = (containerRef, forwardStageRef) => (react_1.default.createElement(TimeslipChartLayers, { forwardStageRef: forwardStageRef, containerRef: containerRef }));
exports.TimeslipWithTooltip = TimeslipWithTooltip;
//# sourceMappingURL=timeslip_chart.js.map