"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.xyVisFunction = void 0;
var _constants = require("../constants");
var _i18n = require("../i18n");
var _common_xy_args = require("./common_xy_args");
var _common_data_layer_args = require("./common_data_layer_args");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const xyVisFunction = exports.xyVisFunction = {
  name: _constants.XY_VIS,
  type: 'render',
  inputTypes: ['datatable'],
  help: _i18n.strings.getXYHelp(),
  args: {
    ..._common_xy_args.commonXYArgs,
    ..._common_data_layer_args.commonDataLayerArgs,
    xAccessor: {
      types: ['string', 'vis_dimension'],
      help: _i18n.strings.getXAccessorHelp()
    },
    splitAccessors: {
      types: ['string', 'vis_dimension'],
      help: _i18n.strings.getSplitAccessorHelp(),
      multi: true
    },
    accessors: {
      types: ['string', 'vis_dimension'],
      help: _i18n.strings.getAccessorsHelp(),
      multi: true
    },
    referenceLines: {
      types: [_constants.REFERENCE_LINE],
      help: _i18n.strings.getReferenceLinesHelp(),
      multi: true
    },
    splitColumnAccessor: {
      types: ['vis_dimension', 'string'],
      help: _i18n.strings.getSplitColumnAccessorHelp()
    },
    splitRowAccessor: {
      types: ['vis_dimension', 'string'],
      help: _i18n.strings.getSplitRowAccessorHelp()
    },
    markSizeAccessor: {
      types: ['vis_dimension', 'string'],
      help: _i18n.strings.getMarkSizeAccessorHelp()
    }
  },
  async fn(data, args, handlers) {
    const {
      xyVisFn
    } = await Promise.resolve().then(() => _interopRequireWildcard(require('./xy_vis_fn')));
    return await xyVisFn(data, args, handlers);
  }
};