"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExpressionShapePlugin = void 0;
var _expression_renderers = require("./expression_renderers");
var _expression_functions = require("../common/expression_functions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

class ExpressionShapePlugin {
  setup(core, {
    expressions
  }) {
    core.getStartServices().then(([start]) => {
      expressions.registerFunction(_expression_functions.shapeFunction);
      expressions.registerFunction(_expression_functions.progressFunction);
      expressions.registerRenderer((0, _expression_renderers.shapeRendererFactory)(start));
      expressions.registerRenderer((0, _expression_renderers.progressRendererFactory)(start));
    });
  }
  start(core) {}
  stop() {}
}
exports.ExpressionShapePlugin = ExpressionShapePlugin;