"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.partitionVisWrapperStyle = exports.partitionVisContainerWithToggleStyleFactory = exports.partitionVisContainerStyle = void 0;
var _react = require("@emotion/react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const partitionVisWrapperStyle = exports.partitionVisWrapperStyle = (0, _react.css)({
  display: 'flex',
  flex: '1 1 auto',
  minHeight: 0,
  minWidth: 0,
  width: '100%',
  height: '100%'
});
const partitionVisContainerStyle = exports.partitionVisContainerStyle = (0, _react.css)`
  min-height: 0;
  min-width: 0;
  margin-left: auto;
  margin-right: auto;
  width: 100%;
  height: 100%;
`;
const partitionVisContainerWithToggleStyleFactory = theme => (0, _react.css)`
  ${partitionVisContainerStyle}

  inset: 0;
  position: absolute;
  padding: ${theme.size.s};
`;
exports.partitionVisContainerWithToggleStyleFactory = partitionVisContainerWithToggleStyleFactory;