"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ESQLControlsFlyout = ESQLControlsFlyout;
var _react = _interopRequireWildcard(require("react"));
var _esqlValidationAutocomplete = require("@kbn/esql-validation-autocomplete");
var _value_control_form = require("./value_control_form");
var _field_control_form = require("./field_control_form");
var _helpers = require("./helpers");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function ESQLControlsFlyout({
  search,
  variableType,
  queryString,
  esqlVariables,
  onSaveControl,
  onCancelControl,
  cursorPosition,
  initialState,
  closeFlyout
}) {
  const onCreateControl = (0, _react.useCallback)(async (state, variableName) => {
    if (cursorPosition) {
      const query = (0, _helpers.updateQueryStringWithVariable)(queryString, variableName, cursorPosition);
      await (onSaveControl === null || onSaveControl === void 0 ? void 0 : onSaveControl(state, query));
    }
  }, [cursorPosition, onSaveControl, queryString]);
  const onEditControl = (0, _react.useCallback)(async state => {
    await (onSaveControl === null || onSaveControl === void 0 ? void 0 : onSaveControl(state, ''));
  }, [onSaveControl]);
  if (variableType === _esqlValidationAutocomplete.ESQLVariableType.VALUES || variableType === _esqlValidationAutocomplete.ESQLVariableType.TIME_LITERAL) {
    return /*#__PURE__*/_react.default.createElement(_value_control_form.ValueControlForm, {
      queryString: queryString,
      esqlVariables: esqlVariables,
      variableType: variableType,
      closeFlyout: closeFlyout,
      onCancelControl: onCancelControl,
      initialState: initialState,
      onCreateControl: onCreateControl,
      onEditControl: onEditControl,
      search: search
    });
  } else if (variableType === _esqlValidationAutocomplete.ESQLVariableType.FIELDS) {
    return /*#__PURE__*/_react.default.createElement(_field_control_form.FieldControlForm, {
      variableType: variableType,
      esqlVariables: esqlVariables,
      queryString: queryString,
      onCancelControl: onCancelControl,
      onCreateControl: onCreateControl,
      onEditControl: onEditControl,
      initialState: initialState,
      closeFlyout: closeFlyout,
      search: search,
      cursorPosition: cursorPosition
    });
  }
  return null;
}