"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.commaCompleteItem = exports.colonCompleteItem = exports.allStarConstant = void 0;
exports.getAssignmentDefinitionCompletitionItem = getAssignmentDefinitionCompletitionItem;
exports.semiColonCompleteItem = exports.pipeCompleteItem = exports.listCompleteItem = exports.getCommandAutocompleteDefinitions = void 0;
var _i18n = require("@kbn/i18n");
var _builtin = require("../definitions/builtin");
var _factories = require("./factories");
var _helpers = require("../shared/helpers");
var _helpers2 = require("../definitions/helpers");
var _documentation_util = require("./documentation_util");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const techPreviewLabel = _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.autocomplete.techPreviewLabel', {
  defaultMessage: `Technical Preview`
});
function getAssignmentDefinitionCompletitionItem() {
  const assignFn = _builtin.builtinFunctions.find(({
    name
  }) => name === '=');
  return (0, _factories.getOperatorSuggestion)(assignFn);
}
const getCommandAutocompleteDefinitions = commands => {
  const suggestions = [];
  for (const command of commands) {
    var _command$types;
    if (command.hidden) {
      continue;
    }
    const commandDefinition = (0, _helpers.getCommandDefinition)(command.name);
    const label = commandDefinition.name.toUpperCase();
    const text = commandDefinition.signature.params.length ? `${commandDefinition.name.toUpperCase()} $0` : commandDefinition.name.toUpperCase();
    const types = (_command$types = command.types) !== null && _command$types !== void 0 ? _command$types : [{
      name: '',
      description: ''
    }];
    for (const type of types) {
      let detail = type.description || commandDefinition.description;
      if (commandDefinition.preview) {
        detail = `[${techPreviewLabel}] ${detail}`;
      }
      const commandSignature = (0, _helpers2.getCommandSignature)(commandDefinition, type.name);
      const suggestion = {
        label: type.name ? `${type.name.toLocaleUpperCase()} ${label}` : label,
        text: type.name ? `${type.name.toLocaleUpperCase()} ${text}` : text,
        asSnippet: true,
        kind: 'Method',
        detail,
        documentation: {
          value: (0, _documentation_util.buildDocumentation)(commandSignature.declaration, commandSignature.examples)
        },
        sortText: 'A-' + label + '-' + type.name,
        command: _factories.TRIGGER_SUGGESTION_COMMAND
      };
      suggestions.push(suggestion);
    }
  }
  return suggestions;
};
exports.getCommandAutocompleteDefinitions = getCommandAutocompleteDefinitions;
function buildCharCompleteItem(label, detail, {
  sortText,
  quoted
} = {
  quoted: false
}) {
  return {
    label,
    text: quoted ? `"${label}"` : label,
    kind: 'Keyword',
    detail,
    sortText
  };
}
const pipeCompleteItem = exports.pipeCompleteItem = {
  label: '|',
  text: '| ',
  kind: 'Keyword',
  detail: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.autocomplete.pipeDoc', {
    defaultMessage: 'Pipe (|)'
  }),
  sortText: 'C',
  command: _factories.TRIGGER_SUGGESTION_COMMAND
};
const commaCompleteItem = exports.commaCompleteItem = buildCharCompleteItem(',', _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.autocomplete.commaDoc', {
  defaultMessage: 'Comma (,)'
}), {
  sortText: 'B',
  quoted: false
});
const colonCompleteItem = exports.colonCompleteItem = buildCharCompleteItem(':', _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.autocomplete.colonDoc', {
  defaultMessage: 'Colon (:)'
}), {
  sortText: 'A',
  quoted: true
});
const semiColonCompleteItem = exports.semiColonCompleteItem = buildCharCompleteItem(';', _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.autocomplete.semiColonDoc', {
  defaultMessage: 'Semi colon (;)'
}), {
  sortText: 'A',
  quoted: true
});
const listCompleteItem = exports.listCompleteItem = {
  label: '( ... )',
  text: '( $0 )',
  asSnippet: true,
  kind: 'Operator',
  detail: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.autocomplete.listDoc', {
    defaultMessage: 'List of items ( ...)'
  }),
  sortText: 'A',
  command: _factories.TRIGGER_SUGGESTION_COMMAND
};
const allStarConstant = exports.allStarConstant = {
  label: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.autocomplete.allStarConstantDoc', {
    defaultMessage: 'All (*)'
  }),
  text: '*',
  kind: 'Constant',
  detail: _i18n.i18n.translate('kbn-esql-validation-autocomplete.esql.autocomplete.allStarConstantDoc', {
    defaultMessage: 'All (*)'
  }),
  sortText: '1'
};