"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.countEntitiesRoute = void 0;
var _zod = require("@kbn/zod");
var _create_entity_manager_server_route = require("../create_entity_manager_server_route");
var _constants = require("../../lib/v2/constants");
var _types = require("../../lib/v2/types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const countEntitiesRoute = exports.countEntitiesRoute = (0, _create_entity_manager_server_route.createEntityManagerServerRoute)({
  endpoint: 'POST /internal/entities/v2/_count',
  security: {
    authz: {
      requiredPrivileges: [_constants.READ_ENTITIES_PRIVILEGE]
    }
  },
  params: _zod.z.object({
    body: _types.countByTypesRt
  }),
  handler: async ({
    request,
    response,
    params,
    getScopedClient
  }) => {
    const client = await getScopedClient({
      request
    });
    const result = await client.v2.countEntities(params.body);
    return response.ok({
      body: result
    });
  }
});