"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Plugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _rxjs = require("rxjs");
var _public = require("@kbn/core/public");
var _public2 = require("@kbn/entityManager-plugin/public");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
class Plugin {
  constructor(context) {
    (0, _defineProperty2.default)(this, "logger", void 0);
    (0, _defineProperty2.default)(this, "appUpdater$", new _rxjs.BehaviorSubject(() => ({})));
    this.context = context;
    this.logger = context.logger.get();
  }
  setup(core, pluginSetup) {
    const kibanaVersion = this.context.env.packageInfo.version;
    const mount = async params => {
      const {
        renderApp
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('./application')));
      const [coreStart, pluginsStart] = await core.getStartServices();
      return renderApp({
        appMountParameters: params,
        core: coreStart,
        isDev: this.context.env.mode.dev,
        kibanaVersion,
        usageCollection: pluginSetup.usageCollection,
        ObservabilityPageTemplate: pluginsStart.observabilityShared.navigation.PageTemplate,
        plugins: pluginsStart,
        isServerless: !!pluginsStart.serverless,
        entityClient: new _public2.EntityClient(core)
      });
    };
    const appUpdater$ = this.appUpdater$;
    const app = {
      id: 'entity_manager',
      title: 'Entity Manager',
      order: 8002,
      updater$: appUpdater$,
      euiIconType: 'logoObservability',
      appRoute: '/app/entity_manager',
      category: _public.DEFAULT_APP_CATEGORIES.observability,
      mount,
      visibleIn: [],
      keywords: ['observability', 'monitor', 'entities'],
      status: _public.AppStatus.inaccessible
    };
    core.application.register(app);
    return {};
  }
  start() {
    return {};
  }
  stop() {}
}
exports.Plugin = Plugin;