"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useVectorSearchBreadcrumbs = exports.useSemanticSearchBreadcrumbs = exports.useSearchExperiencesBreadcrumbs = exports.useSearchBreadcrumbs = exports.useGenerateBreadcrumbs = exports.useEuiBreadcrumbs = exports.useEnterpriseSearchContentBreadcrumbs = exports.useEnterpriseSearchBreadcrumbs = exports.useEnterpriseSearchApplicationsBreadcrumbs = exports.useElasticsearchBreadcrumbs = exports.useAnalyticsBreadcrumbs = exports.useAiSearchBreadcrumbs = void 0;
var _kea = require("kea");
var _i18n = require("@kbn/i18n");
var _constants = require("../../../../common/constants");
var _strip_slashes = require("../../../../common/strip_slashes");
var _http = require("../http");
var _kibana = require("../kibana");
var _react_router_helpers = require("../react_router_helpers");
var _breadcrumbs_home = require("./breadcrumbs_home");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Types
 */

// A trail of breadcrumb text

/**
 * Generate an array of breadcrumbs based on:
 * 1. A passed array of breadcrumb text (the trail prop)
 * 2. The current React Router path
 *
 * To correctly generate working breadcrumbs, ensure the trail array passed to
 * SetPageChrome matches up with the routed path. For example, a page with a trail of:
 *    `['Groups', 'Example Group Name', 'Source Prioritization']`
 * should have a router pathname of:
 *   `'/groups/{example-group-id}/source_prioritization'`
 *
 * Which should then generate the following breadcrumb output:
 * Groups (linked to `/groups`)
 * > Example Group Name (linked to `/groups/{example-group-id}`)
 * > Source Prioritization (linked to `/groups/{example-group-id}/source_prioritization`)
 */

const useGenerateBreadcrumbs = trail => {
  const {
    history
  } = (0, _kea.useValues)(_kibana.KibanaLogic);
  const pathArray = (0, _strip_slashes.stripLeadingSlash)(history.location.pathname).split('/');
  return trail.map((text, i) => {
    const path = pathArray[i] ? '/' + pathArray.slice(0, i + 1).join('/') : undefined;
    return {
      text,
      path
    };
  });
};

/**
 * Convert IBreadcrumb objects to React-Router-friendly EUI breadcrumb objects
 * https://elastic.github.io/eui/#/navigation/breadcrumbs
 *
 * NOTE: Per EUI best practices, we remove the link behavior and
 * generate an inactive breadcrumb for the last breadcrumb in the list.
 */
exports.useGenerateBreadcrumbs = useGenerateBreadcrumbs;
const useEuiBreadcrumbs = breadcrumbs => {
  const {
    navigateToUrl,
    history
  } = (0, _kea.useValues)(_kibana.KibanaLogic);
  const {
    http
  } = (0, _kea.useValues)(_http.HttpLogic);
  return breadcrumbs.map(({
    text,
    path,
    shouldNotCreateHref
  }, i) => {
    const breadcrumb = {
      text
    };
    const isLastBreadcrumb = i === breadcrumbs.length - 1;
    if (path && !isLastBreadcrumb) {
      breadcrumb.href = (0, _react_router_helpers.createHref)(path, {
        history,
        http
      }, {
        shouldNotCreateHref
      });
      breadcrumb.onClick = event => {
        if ((0, _react_router_helpers.letBrowserHandleEvent)(event)) return;
        event.preventDefault();
        navigateToUrl(path, {
          shouldNotCreateHref
        });
      };
    }
    return breadcrumb;
  });
};

/**
 * Product-specific breadcrumb helpers
 */
exports.useEuiBreadcrumbs = useEuiBreadcrumbs;
const useSearchBreadcrumbs = (breadcrumbs = []) => useEuiBreadcrumbs([{
  text: _constants.SEARCH_PRODUCT_NAME,
  path: (0, _breadcrumbs_home.getHomeURL)(),
  shouldNotCreateHref: true
}, ...breadcrumbs]);
exports.useSearchBreadcrumbs = useSearchBreadcrumbs;
const useEnterpriseSearchBreadcrumbs = (breadcrumbs = []) => useEuiBreadcrumbs([{
  text: _constants.ENTERPRISE_SEARCH_PRODUCT_NAME,
  path: (0, _breadcrumbs_home.getHomeURL)(),
  shouldNotCreateHref: true
}, ...breadcrumbs]);
exports.useEnterpriseSearchBreadcrumbs = useEnterpriseSearchBreadcrumbs;
const useAnalyticsBreadcrumbs = (breadcrumbs = []) => useSearchBreadcrumbs([{
  text: _constants.APPLICATIONS_PLUGIN.NAV_TITLE
}, {
  text: _constants.ANALYTICS_PLUGIN.NAME,
  path: '/'
}, ...breadcrumbs]);
exports.useAnalyticsBreadcrumbs = useAnalyticsBreadcrumbs;
const useElasticsearchBreadcrumbs = (breadcrumbs = []) => useSearchBreadcrumbs([{
  text: _i18n.i18n.translate('xpack.enterpriseSearch.elasticsearch.breadcrumbs.title', {
    defaultMessage: 'Getting started with Elasticsearch'
  }),
  path: '/'
}, ...breadcrumbs]);
exports.useElasticsearchBreadcrumbs = useElasticsearchBreadcrumbs;
const useEnterpriseSearchContentBreadcrumbs = (breadcrumbs = []) => useSearchBreadcrumbs([{
  text: _constants.ENTERPRISE_SEARCH_CONTENT_PLUGIN.NAV_TITLE
}, ...breadcrumbs]);
exports.useEnterpriseSearchContentBreadcrumbs = useEnterpriseSearchContentBreadcrumbs;
const useSearchExperiencesBreadcrumbs = (breadcrumbs = []) => useSearchBreadcrumbs([{
  text: _constants.SEARCH_EXPERIENCES_PLUGIN.NAV_TITLE,
  path: '/'
}, ...breadcrumbs]);
exports.useSearchExperiencesBreadcrumbs = useSearchExperiencesBreadcrumbs;
const useEnterpriseSearchApplicationsBreadcrumbs = (breadcrumbs = []) => useSearchBreadcrumbs([{
  text: _constants.APPLICATIONS_PLUGIN.NAV_TITLE
}, ...breadcrumbs]);
exports.useEnterpriseSearchApplicationsBreadcrumbs = useEnterpriseSearchApplicationsBreadcrumbs;
const useAiSearchBreadcrumbs = (breadcrumbs = []) => useSearchBreadcrumbs([{
  text: _constants.GETTING_STARTED_TITLE
}, {
  text: _constants.AI_SEARCH_PLUGIN.NAME,
  path: '/'
}, ...breadcrumbs]);
exports.useAiSearchBreadcrumbs = useAiSearchBreadcrumbs;
const useVectorSearchBreadcrumbs = (breadcrumbs = []) => useSearchBreadcrumbs([{
  text: _constants.GETTING_STARTED_TITLE
}, {
  text: _constants.VECTOR_SEARCH_PLUGIN.NAV_TITLE,
  path: '/'
}, ...breadcrumbs]);
exports.useVectorSearchBreadcrumbs = useVectorSearchBreadcrumbs;
const useSemanticSearchBreadcrumbs = (breadcrumbs = []) => useSearchBreadcrumbs([{
  text: _constants.GETTING_STARTED_TITLE
}, {
  text: _constants.SEMANTIC_SEARCH_PLUGIN.NAME,
  path: '/'
}, ...breadcrumbs]);
exports.useSemanticSearchBreadcrumbs = useSemanticSearchBreadcrumbs;