"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchIndex = exports.FetchIndexApiLogic = void 0;
var _create_api_logic = require("../../../shared/api_logic/create_api_logic");
var _http = require("../../../shared/http");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const fetchIndex = async ({
  indexName
}) => {
  const route = `/internal/enterprise_search/indices/${indexName}`;
  return await _http.HttpLogic.values.http.get(route);
};
exports.fetchIndex = fetchIndex;
const FetchIndexApiLogic = exports.FetchIndexApiLogic = (0, _create_api_logic.createApiLogic)(['fetch_index_api_logic'], fetchIndex, {
  clearFlashMessagesOnMakeRequest: false,
  showErrorFlash: false
});