"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.putConnectorFilteringDraft = exports.ConnectorFilteringDraftApiLogic = void 0;
var _i18n = require("@kbn/i18n");
var _create_api_logic = require("../../../shared/api_logic/create_api_logic");
var _http = require("../../../shared/http");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const putConnectorFilteringDraft = async ({
  advancedSnippet,
  connectorId,
  filteringRules
}) => {
  const route = `/internal/enterprise_search/connectors/${connectorId}/filtering/draft`;
  return await _http.HttpLogic.values.http.put(route, {
    body: JSON.stringify({
      advanced_snippet: advancedSnippet,
      filtering_rules: filteringRules
    })
  });
};
exports.putConnectorFilteringDraft = putConnectorFilteringDraft;
const ConnectorFilteringDraftApiLogic = exports.ConnectorFilteringDraftApiLogic = (0, _create_api_logic.createApiLogic)(['content', 'connector_filtering_draft_api_logic'], putConnectorFilteringDraft, {
  showSuccessFlashFn: () => _i18n.i18n.translate('xpack.enterpriseSearch.content.index.connector.syncRules.successToastDraft.title', {
    defaultMessage: 'Draft rules saved'
  })
});