"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.generateApiKey = exports.GenerateConnectorApiKeyApiLogic = void 0;
var _create_api_logic = require("../../../shared/api_logic/create_api_logic");
var _http = require("../../../shared/http");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const generateApiKey = async ({
  indexName,
  isNative
}) => {
  const route = `/internal/enterprise_search/indices/${indexName}/api_key`;
  const params = {
    is_native: isNative
  };
  return await _http.HttpLogic.values.http.post(route, {
    body: JSON.stringify(params)
  });
};
exports.generateApiKey = generateApiKey;
const GenerateConnectorApiKeyApiLogic = exports.GenerateConnectorApiKeyApiLogic = (0, _create_api_logic.createApiLogic)(['generate_connector_api_key_api_logic'], generateApiKey);