"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transformToUpdateScheme = exports.appendConversationMessages = void 0;
var _get_conversation = require("./get_conversation");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const appendConversationMessages = async ({
  esClient,
  logger,
  conversationIndex,
  existingConversation,
  messages
}) => {
  var _existingConversation, _response8, _response9;
  const updatedAt = new Date().toISOString();
  const params = transformToUpdateScheme(updatedAt, [...((_existingConversation = existingConversation.messages) !== null && _existingConversation !== void 0 ? _existingConversation : []), ...messages]);
  const maxRetries = 3;
  let attempt = 0;
  let response;
  while (attempt < maxRetries) {
    try {
      var _existingConversation2, _response, _response2, _response3, _response4, _response5, _response6, _response7;
      response = await esClient.updateByQuery({
        conflicts: 'proceed',
        index: conversationIndex,
        query: {
          ids: {
            values: [(_existingConversation2 = existingConversation.id) !== null && _existingConversation2 !== void 0 ? _existingConversation2 : '']
          }
        },
        refresh: true,
        script: {
          lang: 'painless',
          params: {
            ...params
          },
          source: `
            if (params.assignEmpty == true || params.containsKey('messages')) {
              def messages = [];
              for (message in params.messages) {
                def newMessage = [:];
                newMessage['@timestamp'] = message['@timestamp'];
                newMessage.content = message.content;
                newMessage.is_error = message.is_error;
                newMessage.reader = message.reader;
                newMessage.role = message.role;
                if (message.trace_data != null) {
                  newMessage.trace_data = message.trace_data;
                }
                if (message.metadata != null) {
                  newMessage.metadata = message.metadata;
                }
                messages.add(newMessage);
              }
              ctx._source.messages = messages;
            }
            ctx._source.updated_at = params.updated_at;
          `
        }
      });
      if ((_response = response) !== null && _response !== void 0 && _response.updated && ((_response2 = response) === null || _response2 === void 0 ? void 0 : _response2.updated) > 0 || (_response3 = response) !== null && _response3 !== void 0 && _response3.failures && ((_response4 = response) === null || _response4 === void 0 ? void 0 : _response4.failures.length) > 0) {
        break;
      }
      if ((_response5 = response) !== null && _response5 !== void 0 && _response5.version_conflicts && ((_response6 = response) === null || _response6 === void 0 ? void 0 : _response6.version_conflicts) > 0 && ((_response7 = response) === null || _response7 === void 0 ? void 0 : _response7.updated) === 0) {
        attempt++;
        if (attempt < maxRetries) {
          logger.warn(`Version conflict detected, retrying appendConversationMessages (attempt ${attempt + 1}) for conversation ID: ${existingConversation.id}`);
          await new Promise(resolve => setTimeout(resolve, 100 * attempt)); // Exponential backoff
        }
      } else {
        break;
      }
    } catch (err) {
      logger.error(`Error appending conversation messages: ${err} for conversation by ID: ${existingConversation.id}`);
      throw err;
    }
  }
  if (response && (_response8 = response) !== null && _response8 !== void 0 && _response8.failures && ((_response9 = response) === null || _response9 === void 0 ? void 0 : _response9.failures.length) > 0) {
    var _response10;
    logger.error(`Error appending conversation messages: ${(_response10 = response) === null || _response10 === void 0 ? void 0 : _response10.failures.map(f => f.id)} for conversation by ID: ${existingConversation.id}`);
    return null;
  }
  const updatedConversation = await (0, _get_conversation.getConversation)({
    esClient,
    conversationIndex,
    id: existingConversation.id,
    logger
  });
  return updatedConversation;
};
exports.appendConversationMessages = appendConversationMessages;
const transformToUpdateScheme = (updatedAt, messages) => {
  return {
    updated_at: updatedAt,
    messages: messages === null || messages === void 0 ? void 0 : messages.map(message => ({
      '@timestamp': message.timestamp,
      content: message.content,
      is_error: message.isError,
      reader: message.reader,
      role: message.role,
      ...(message.metadata ? {
        metadata: {
          ...(message.metadata.contentReferences ? {
            content_references: message.metadata.contentReferences
          } : {})
        }
      } : {}),
      ...(message.traceData ? {
        trace_data: {
          trace_id: message.traceData.traceId,
          transaction_id: message.traceData.transactionId
        }
      } : {})
    }))
  };
};
exports.transformToUpdateScheme = transformToUpdateScheme;